% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMobjects.R
\name{PerformanceMetric}
\alias{PerformanceMetric}
\alias{P10}
\alias{P50}
\alias{P100}
\alias{PNOF}
\alias{LTY}
\alias{STY}
\alias{Yield}
\alias{AAVY}
\alias{AAVE}
\title{Performance Metrics Methods}
\usage{
P10(MSEobj = NULL, Ref = 0.1, Yrs = NULL)

P50(MSEobj = NULL, Ref = 0.5, Yrs = NULL)

P100(MSEobj = NULL, Ref = 1, Yrs = NULL)

PNOF(MSEobj = NULL, Ref = 1, Yrs = NULL)

LTY(MSEobj = NULL, Ref = 0.5, Yrs = -10)

STY(MSEobj = NULL, Ref = 0.5, Yrs = 10)

Yield(MSEobj = NULL, Ref = 1, Yrs = NULL)

AAVY(MSEobj = NULL, Ref = 0.2, Yrs = NULL)

AAVE(MSEobj = NULL, Ref = 0.2, Yrs = NULL)
}
\arguments{
\item{MSEobj}{An object of class MSE}

\item{Ref}{Reference point for calculating the performance metric. See details.}

\item{Yrs}{Numeric vector of length 2 with year indices to summarize performance.
If NULL, the performance is summarized over all projection years.}
}
\value{
An object of class \code{PMobj}
}
\description{
Performance metric (PMs) methods for your management strategy evaluation.
}
\details{
Performance Metric definitions:

\tabular{ll}{
\code{P10} \tab Probability B > 0.1 BMSY \cr
\code{P50} \tab Probability B > 0.5 BMSY \cr
\code{P100} \tab Probability B > BMSY \cr
\code{PNOF} \tab Probability F < FMSY \cr
\code{LTY} \tab Probability Long-Term Yield > 0.5 Relative Yield \cr
\code{STY} \tab Probability Short-Term Yield > 0.5 Relative Yield \cr
\code{AAVY} \tab Probability AAVY < 0.2 (Average Annual Variability in Yield) \cr
\code{AAVE} \tab Probability AAVE < 0.2 (Average Annual Variability in Effort) \cr
\code{Yield} \tab Average Yield (relative to Reference Yield) \cr
}

Argument \code{Ref} provides the ratio relative to the reference point for calculating
the performance metric. For biomass-based PMs (\code{P10}, \code{P50}, \code{P100}), this is the fraction of
BMSY. For \code{PNOF}, the fraction of FMSY. For \code{Yield} (and \code{LTY}/\code{STY}), the fraction of the
Reference Yield. For \code{AAVY} is it the maximum acceptable variability in yield (i.e, default
for \code{AAVY} is \code{Ref=0.2})

The \code{Yrs} argument defines the number of years to calculate the performance statistic over.
A value of \code{NULL}, the default for \code{AAVY}, \code{AAVE}, \code{P10}, \code{P50}, \code{P100}, and \code{PNOF}, means that the
performance metric is calculated over all projection years. A numeric vector of length two is used
to specify the first and last year, e.g, if \code{Yrs=c(1,10)} the performance statistic is calculated
over the first 10 projection years. A numeric vector of length one with positive or negative value
respectively can be used to specify the first \emph{x} or last \emph{x} years, e.g, \code{Yrs=10} is first 10 years,
and \code{Yrs=-10} is the last 10 years. See \code{\link{ChkYrs}} for more details.

By default Long-Term Yield (\code{LTY}) is the Yield in the last ten years of the projection period in the MSE,
and Short-Term Yield (\code{STY}) is that in the first 10 years of the projection period.
}
\examples{
\dontrun{
myMSE <- runMSE()
P10(myMSE)
P50(myMSE)
P100(myMSE)
PNOF(myMSE)
LTY(myMSE)
STY(myMSE)
AAVY(myMSE)
AAVE(myMSE)
Yield(myMSE)
}
}
