% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSCAM2OM.R
\name{iSCAM2OM}
\alias{iSCAM2OM}
\title{Reads MLE estimates from iSCAM file structure into an operating model}
\usage{
iSCAM2OM(
  iSCAMdir,
  nsim = 48,
  proyears = 50,
  mcmc = F,
  Name = NULL,
  Source = "No source provided",
  length_timestep = 1,
  nyr_par_mu = 2,
  Author = "No author provided",
  report = F,
  silent = F
)
}
\arguments{
\item{iSCAMdir}{A folder with iSCAM input and output files in it}

\item{nsim}{The number of simulations to take for parameters with
uncertainty (for OM@cpars custom parameters)}

\item{proyears}{The number of MSE projection years}

\item{mcmc}{Whether to use mcmc samples to create custom parameters cpars}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{length_timestep}{How long is a model time step in years
(e.g. a quarterly model is 0.25, a monthly model 1/12)}

\item{nyr_par_mu}{integer, the number of recent years to estimate vulnerability over for future projections}

\item{Author}{Who did the assessment}

\item{report}{logical should a numbers at age reconstruction plot be produced?}

\item{silent}{logical should progress reporting be printed to the console?}
}
\description{
A function that uses the file location of a fitted iSCAM
model including input files to population the various slots of an
operating model parameter estimates. iSCAM2OM relies on several
functions written by Chris Grandin (DFO PBS).
}
\author{
T. Carruthers
}
