% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_SSS.R
\name{SSS}
\alias{SSS}
\title{Simple Stock Synthesis}
\usage{
SSS(
  x = 1,
  Data,
  dep = 0.4,
  SR = c("BH", "Ricker"),
  rescale = "mean1",
  start = NULL,
  silent = TRUE,
  opt_hess = FALSE,
  n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 2e+05, eval.max = 4e+05),
  ...
)
}
\arguments{
\item{x}{A position in the Data object (by default, equal to one for assessments).}

\item{Data}{An object of class Data}

\item{dep}{Depletion value to use in the model. Can be an expression that will be evaluated inside the function.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt or \code{"Ricker"}).}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{start}{Optional named list of starting values. Entries can be expressions that are evaluated in the function:
\itemize{
\item R0 - unfished recruitment
\item vul_par - a length-two vector for the age of 95\% and 50\% fleet selectivity. Fixed to maturity otherwise.
}}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for dignostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate).}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of agruments for optimization to be passed to \code{\link[stats]{nlminb}}.}

\item{...}{Other arguments to be passed (not currently used).}
}
\description{
A simple age-structured model (\link{SCA_Pope}) fitted to a time series of catch going back to unfished conditions.
Terminal depletion (ratio of current biomass to unfished biomass) is by default fixed to 0.4.
Selectivity is fixed to the maturity ogive,
although it can be overridden with the start argument. The sole parameter estimated is R0 (unfished recruitment).
}
\examples{
res <- SSS(1, Data = Red_snapper)

SSS_MP <- make_MP(SSS, HCR40_10, dep = 0.3) # Always assume depletion = 0.3
}
\references{
Cope, J.M. 2013. Implementing a statistical catch-at-age model (Stock Synthesis) as a tool for
deriving overfishing limits in data-limited situations. Fisheries Research 142:3-14.
}
\author{
Q. Huynh
}
