% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMSE_Object.R
\docType{class}
\name{MMSE-class}
\alias{MMSE-class}
\title{Class \code{'MMSE'}}
\description{
A Multi Management Strategy Evaluation object that contains information about
simulation conditions and performance of MPs for a multi-stock, multi-fleet operating model.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the MMSE object. Single value. Character string}

\item{\code{nyears}}{The number of years for the historical simulation. Single value. Positive integer}

\item{\code{proyears}}{The number of years for the projections - closed loop simulations. Single value. Positive integer}

\item{\code{nMPs}}{Number of management procedures simulation tested. Single value. Positive integer.}

\item{\code{MPs}}{The names of the MPs that were tested. Vector of length nMPs. Character strings.}

\item{\code{MPcond}}{The MP condition. Character ('bystock': an MP per stock, 'byfleet' and MP per stock and fleet, 'MMP' an MP for all stocks and fleets)}

\item{\code{MPrefs}}{The names of the MPs applied for each stock (row) and fleet (column). An array.}

\item{\code{nsim}}{Number of simulations. Single value. Positive integer}

\item{\code{nstocks}}{Number of stocks. Single value. Positive integer}

\item{\code{nfleets}}{Number of fleets. Single value. Positive integer}

\item{\code{Snames}}{Names of the stocks}

\item{\code{Fnames}}{Names of the fleets (matrix nstocks x nfleets)}

\item{\code{Stocks}}{The stock operating model objects. List of Stocks}

\item{\code{Fleets}}{The fleet operating model objects. Hierarchical list, fleets nested in stocks.}

\item{\code{Obss}}{The fleet specific observation error operating model objects. Hierarchical list, fleets nested in stocks.}

\item{\code{Imps}}{The fleet soecific implementation error operating model objects. Hierarchical list, fleets nested in stocks.}

\item{\code{OM}}{A table of sampled parameters of the operating model. Data frame of nsim rows.}

\item{\code{Obs}}{A table of sampled parameters of the observation model. Data frame of nsim rows.}

\item{\code{B_BMSY}}{Simulated biomass relative to BMSY over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{F_FMSY}}{Simulated fishing mortality rate relative to FMSY over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{B}}{Simulated stock biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB}}{Simulated spawning stock biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{VB}}{Simulated vulnerable biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{FM}}{Simulated fishing mortality rate over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{C}}{Simulated catches (taken) over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{TAC}}{Simulated Total Allowable Catch (prescribed) over the projection (this is NA for input controls). An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB_hist}}{Simulated historical spawning stock biomass. An array with dimensions: nsim, nages, nyears, nareas. Non-negative real numbers}

\item{\code{CB_hist}}{Simulated historical catches in weight. An array with dimensions: nsim, nages, nyears, nareas. Non-negative real numbers}

\item{\code{FM_hist}}{Simulated historical fishing mortality rate. An array with dimensions: nsim, nages, nyears, nareas. Non-negative real numbers}

\item{\code{Effort}}{Simulated relative fishing effort in the projection years. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{PAA}}{Population at age in last projection year. An array with dimensions: nsim, nMPs, nages. Non-negative real numbers}

\item{\code{CAA}}{Catch at age in last projection year. An array with dimensions: nsim, nMPs, nages. Non-negative real numbers}

\item{\code{CAL}}{Catch at length in last projection year. An array with dimensions: nsim, nMPs, nCALbins. Non-negative real numbers}

\item{\code{CALbins}}{Mid-points of the catch-at-length bins. Vector of length nCALbins. Positive real numbers.}

\item{\code{MSY_P}}{Array of projected MSY by year with dimensions: nsim, nstock, nMP, proyears.}

\item{\code{FMSY_P}}{Array of projected FMSY by year with dimensions: nsim, nstock, nMP, proyears.}

\item{\code{SSBMSY_P}}{Array of projected Spawning Stock Biomass at MSY by year with dimensions: nsim, nstock, nMP, proyears.}

\item{\code{Misc}}{Miscellanenous output such as posterior predictive data}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('MMSE', Name, nyears, proyears, nMPs, MPs, nsim, OMtable, Obs,
B_BMSYa, F_FMSYa, Ba, FMa, Ca, OFLa, Effort, PAA, CAA, CAL, CALbins)}
}

\author{
T. Carruthers
}
\keyword{classes}
