% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CASAL2OM.R
\name{CASAL2OM}
\alias{CASAL2OM}
\title{Reads MLE estimates from CASAL file structure into an operating model}
\usage{
CASAL2OM(CASALdir, Obs = DLMtool::Precise_Unbiased,
  Imp = DLMtool::Perfect_Imp, Name = NA, Agency = NA, Region = NA,
  Sponsor = NA, Latitude = NA, Longitude = NA, nsim = 48,
  proyears = 50, interval = 4, pstar = 0.5, maxF = 2, reps = 1,
  seed = 1, Common_Name = NA, Species = NA, Source = NA,
  Author = NA)
}
\arguments{
\item{CASALdir}{A folder with Stock Synthesis input and output files in it}

\item{Obs}{The observation model (class Obs).}

\item{Imp}{The implementation model (class Imp).}

\item{Name}{The common name of the operating model}

\item{Agency}{The fishery management agency}

\item{Region}{The geographical location}

\item{Sponsor}{Who funded the work}

\item{Latitude}{In degrees north}

\item{Longitude}{In degrees west}

\item{nsim}{The number of simulations to take for parameters with uncertainty (for OM@cpars custom parameters).}

\item{proyears}{The number of projection years for MSE}

\item{interval}{The number of years between management updates}

\item{pstar}{The quantile for TAC management given stochasticity}

\item{maxF}{The maximum allowable F in the operating model.}

\item{reps}{The number of stochastic replicates within each simulation in the operating model.}

\item{seed}{The random seed for the operating model.}

\item{Common_Name}{The name of the species}

\item{Species}{The species latin name}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{Author}{Who did the assessment}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}.}
}
\value{
An object of class OM.
}
\description{
A (prototype) function that uses the file location of a fitted CASAL assessment model including input files to population the
various slots of an operating model with MLE parameter estimates. The function mainly populates the Stock and Fleet portions
of the operating model; the user still needs to parameterize most of the observation and implementation portions of the operating model.
}
\seealso{
\link{SS2OM}
}
\author{
T. Carruthers
}
