% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn_MICE.R
\name{popdynOneMICE}
\alias{popdynOneMICE}
\title{Population dynamics for a MICE model (single year)}
\usage{
popdynOneMICE(np, nf, nareas, maxage, Ncur, Vcur, FMretx, FMx, PerrYrp,
  hsx, aRx, bRx, movy, Spat_targ, SRrelx, M_agecur, Mat_agecur, Asizex, Kx,
  Linfx, t0x, Mx, R0x, R0ax, SSBpRx, ax, bx, Rel, SexPars, x)
}
\arguments{
\item{np}{Integer, the number of stocks}

\item{nf}{Integer, number of fleets}

\item{maxage}{Integer, maximum modelled age}

\item{Ncur}{Array [stock, age, area] of stock numbers}

\item{Vcur}{Array [fleet, age, area] of the vulnerability curve}

\item{FMretx}{Array [stock, fleet, age, area] of the retention curve}

\item{FMx}{Array [stock, fleet, age, area] fishing mortality rate}

\item{PerrYrp}{Vector [stock] process error - the lognormal factor for recruitment strength}

\item{hsx}{Vector [stock] steepness of the stock recruitment curve}

\item{aRx}{Vector [stock] stock recruitment parameter alpha (for Ricker curve)}

\item{bRx}{Vector [stock] stock recruitment parameter beta (for Ricker curve)}

\item{movy}{Array [stock,age,area,area] of movement transitions}

\item{Spat_targ}{Matrix [stock, fleet] of spatial targetting parameter (0 evenly spatial distributed, 1 proportional to vulnerable biomass)}

\item{SRrelx}{Integer vector [stock] the form of the stock recruitment relationship (1 = Beverton-Holt, 2= Ricker)}

\item{M_agecur}{Matrix [stock, age] of Natural mortality rate at age}

\item{Mat_agecur}{Matrix [stock, age] of maturity (spawning fraction) age age}

\item{Asizex}{Matrix [stock, area] of relative area sizes}

\item{Kx}{Vector [stock] of von B growth parameter K}

\item{Mx}{Vector [stock] mature natural mortality rate}

\item{R0x}{Vector [stock] unfished recruitment}

\item{R0ax}{Matrix [stock, area] unfished recruitment by area}

\item{SSBpRx}{Matrix [stock, area] spawning biomass per recruit by area}

\item{ax}{Vector [stock] weight-length parameter a W=aL^b}

\item{bx}{Vector [stock] weight-length parameter b W=aL^b}

\item{Rel}{A list of inter-stock relationships see slot Rel of MOM object class}

\item{SexPars}{A list of sex-specific relationships (SSBfrom, stock_age)}

\item{x}{Integer. The simulation number}

\item{nyears}{Integer, number of historical years (unfished til today)}

\item{Linf}{Vector [stock] of von B asymptotic length parameter Linf}

\item{t0}{Vector [stock] of von B theoretical age at zero length (t0)}
}
\description{
Completes a single iteration of recruitment, mortality, fishing and movement given MICE model inputs
}
\author{
T.Carruthers
}
\keyword{internal}
