% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{nodeGroups}
\alias{nodeGroups}
\title{Groups taxa by deleting a node in a tree}
\usage{
nodeGroups(tree, nodeNum)
}
\arguments{
\item{tree}{a tree, of class "phylo"}

\item{nodeNum}{a node number, representing an internal node in the phylo representation}
}
\value{
a list of lists of tree tip numbers for each group.
The union of the groups is the set of all tips.
}
\description{
Finds groups of taxa determined by the connected components of the graph resulting from deleting an internal node in a tree.
}
\details{
When applied to a rooted tree, the last group returned is the set of tips that are
non-descendants of the node (provided any exist).
}
\examples{
 tree=read.tree(text="((a,b),((c,d,e),(f,g)));")
 nodeGroups(tree,8)
 nodeGroups(tree,10)
 nodeGroups(tree,11)

}
