% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_state_matrix.R
\name{make_state_matrix}
\alias{make_state_matrix}
\title{Create a State Matrix}
\usage{
make_state_matrix(
  data,
  id = "link_id",
  ltc = "reg",
  aos = "aos",
  k = 100,
  l = 111,
  fail_code = "death",
  cens_code = "cens"
)
}
\arguments{
\item{data}{A data frame or tibble containing the dataset long format}

\item{id}{A string representing the column name of patients ID}

\item{ltc}{A string representing the column name of the event (long term conditions)}

\item{aos}{A string representing the column name of age at onset of considered long term conditions}

\item{k}{An integer representing the group size when splitting the dataset (usefull for large datasets)}

\item{l}{An integer representing the number of rows of the state matrices. It usualle represent the maximum age of patients}

\item{fail_code}{A string representing the code used for failure (death)}

\item{cens_code}{A string representing the code used for censoring}
}
\value{
A list of state matrices, one per patient
}
\description{
This function generates state matrices based on the given dataset, with options for
defining ID columns, LTC columns, and matrix dimensions. It splits the data, processes
it by group, and computes matrices for each subset of data.
}
\details{
The function processes the data by splitting it based on the \code{id} and \code{ltc} columns.
It computes matrices for each subset, with rows representing different states and columns representing unique IDs.
}
