% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{uphist}
\alias{uphist}
\title{uphist a histogram with an upper limit on the x-axis}
\usage{
uphist(x, maxval = NA, ...)
}
\arguments{
\item{x}{the vector of values to be plotted as a histogram}

\item{maxval}{the maximum value to be retained in the plotted data}

\item{...}{any of the other arguments used by the base hist function}
}
\value{
nothing, but it does plot a histogram
}
\description{
uphist is merely a wrapper around the base hist
    function, which adds the ability to limit the upper value on
    the x-axis. With fisheries data it is surprisingly common to 
    have data that has a very few extreme values that can obscure
    a standard plot of the data. The data are only truncated 
    within the uphist function so any other analyses will be on all 
    available data. If a maximum value is selected which 
    accidently eliminates all available data the script stops with
    an appropriate warning. If a value is selected which fails to 
    eliminate any data then all data are used with no warning.
}
\examples{
  x <- rlnorm(5000, meanlog=2, sdlog=1)
  hist(x,breaks=30,main="",xlab="log-normal values")
  uphist(x,breaks=30,main="",xlab="log-normal values",maxval=100)
  uphist(x,breaks=30,main="",xlab="log-normal values",maxval=1000)
}
