% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{properties}
\alias{properties}
\title{properties - used to examine the properties of a data.frame}
\usage{
properties(indat, dimout = FALSE)
}
\arguments{
\item{indat}{the data.frame containing the columns to be examined.}

\item{dimout}{determines whether or not the dimensions of the data.frame
are printed to the screen or not; defaults to FALSE}
}
\value{
a data.frame with the rows being each variable from the 
    input data.frame and the columns being the number of NAs, the
    number of unique values, the class of variable, and minimum and maximum 
    (where the columns are numeric), and an example value.
}
\description{
properties examines some of the properties of a data.frame 
    and outputs for each column an index for each variable, how many NAs 
    there are, how many unique values there are, the class of each variable,
    the minimum and maximum (of all numeric variables), and an example value.
}
\examples{
data(abdat)
properties(abdat)
}
