% Generated by roxygen2 (4.0.2): do not edit by hand
\name{segmentation}
\alias{segmentation}
\title{segmentation function}
\usage{
segmentation(signal, method = c("cghseg", "PELT"), Rho = NULL, Kmax = 10,
  position = NULL, plot = TRUE, verbose = TRUE)
}
\arguments{
\item{signal}{a vector containing the signal.}

\item{method}{method of segmentation, either "PELT" or "cghseg".}

\item{Rho}{For method="PELT", vector containing all the penalization values to test for the segmentation. If no values are provided, default values will be used.}

\item{Kmax}{For method="cghseg", maximal number of segments.}

\item{position}{A vector containing the position of all elements of the signal (not necessary)}

\item{plot}{if TRUE, plot the segmentation results}

\item{verbose}{if TRUE print some informations}
}
\value{
a list containing
\describe{
  \item{signal}{A vector containing the signal.}
  \item{segmented}{A vector of the same size as signal containing the segmented values.}
  \item{startPos}{The position of each probe.}
  \item{segment}{A data.frame that summarizes the results of the segmentation. Each row is a different segment with the start position, end position, number of points in the signal and the value of the segment.}
}
}
\description{
This function launches the segmentation of a signal.
}
\author{
Quentin Grimonprez
}

