% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_nodata_values.R
\name{split_nodata_values}
\alias{split_nodata_values}
\alias{create_nodata_rcl}
\title{Split NODATA values or create matrix for reclassification}
\usage{
split_nodata_values(nodata_in, take_all = TRUE)

create_nodata_rcl(nodata_in, nodata_out)
}
\arguments{
\item{nodata_in}{Character vector corresponding to input NoData values
as saved in the xml product file (one or more values per band).}

\item{take_all}{Logical: if TRUE (default), all the NoData values are considered;
if FALSE, only the last one is taken.
See "details" for the meaning of this parameter.}

\item{nodata_out}{Character vector corresponding to output NoData values
as saved in the xml product file (one single value per band).}
}
\value{
\link{split_nodata_values}  returns a list with the same length
of \code{nodata_in} vector, in which each element
is a vector with all the NoData values.

\link{create_nodata_rcl} returns a list of matrices in the format
specified for parameter \code{rcl} in \link[raster:reclassify]{raster::reclassify}.
The parameter \code{right} is intended to be used as \code{right = NA}.
}
\description{
Internal functions:
\link{split_nodata_values} splits the ranges of NODATA saved
in the xml product file to a readable vector of NoData values;
\link{create_nodata_rcl} creates the matrix for the reclassification of NODATA
values to be used with \link[raster:reclassify]{raster::reclassify} function.
}
\details{
MODIS products can have more than one NoData values (sometimes
with different meanings, e.g. 255 = "fill" and 254 = "detector saturated"
in \href{https://nsidc.org/data/mod10a1}{MOD09A1} product). By setting
"Change NoData values" to "Yes" in the GUI, all the NoData values are
coerced to one single new NoData value; conversely, setting it to "No"
only one value is assumed to be NoData.
The parameter \code{take_all} is assumed to be used in this way, by using this
function with \code{take_all = TRUE} with "Change NoData values" = "Yes" and
\code{take_all = FALSE} with "Change NoData values" = "No".

In the xml product file, NoData ranges are set as:
\itemize{
\item \code{x} for products with single NoData values;
\item \verb{x,y,z} for products with a vector of NoData values;
\item \code{x:y} for products with a range of NoData values;
\item \verb{x:y,z} for a combination of NoData ranges and/or values.
}

In \link{split_nodata_values} \emph{NoData values are assumed to be integer}:
this means that intervals are splitted in integer values
(e.g. "250:255" becomes "250 251 252 253 254 255").
Conversely, function \link{create_nodata_rcl} creates intervals, so it can also
manage float values (in practice, this should not make difference within
MODIS products, since NoData values are always integer values).

This function interprets these strings and convert them in vectors with
single values.
Notice that the first NoData value is the only one which is considered if
'Change NoData values' was set to 'No'.
}
\examples{
MODIStsp:::create_nodata_rcl(c("255","250,254:255"), c("255","255"))
}
\author{
Luigi Ranghetti, phD (2018) \email{luigi@ranghetti.info}
}
