% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual.R
\name{re.MNB}
\alias{re.MNB}
\title{Residual analysis}
\usage{
re.MNB(star, formula, dataSet)
}
\arguments{
\item{star}{Initial values for the parameters to be optimized over.}

\item{formula}{The structure matrix of covariates of dimension n x p (in models that include an intercept x
should contain a column of ones).}

\item{dataSet}{data}
}
\value{
Residuals
}
\description{
Weighted, standardized weighted, Pearson, standardized Pearson and
standardized deviance component residuals are available to assess possible departures
from the multivariate negative binomial model for fitting correlated data with overdispersion.
}
\details{
Similarly to GLMs theory (Agresti, 2015; Faraway, 2016), weighted and
the standardized weighted residuals are deduced trough Fisher scoring iterative process.
Based in the Pearson residual, Fabio (2017) suggest the standardized Pearson residuals
for the multivariate model from the random intercept Poisson-GLG model. In addition,
it is available the standardized deviance component residual for the ith subject
(Fabio et al., 2012).
}
\examples{

data(seizures)
head(seizures)

star <-list(phi=1, beta0=1, beta1=1, beta2=1, beta3=1)

r <- re.MNB(formula=Y ~ trt + period + trt:period +
offset(weeks),star=star,dataSet=seizures)

plot(r$ij.Sweighted.residual,cex.axis = 1.2, cex.lab = 1.2,
pch = 15,cex = 0.6, bg = 5,ylab="weighted.residual")

abline(h=c(-3,0,3),lwd = 2, lty = 2)

}
\references{
\itemize{
\item Agresti, A. (2015). Foundations of Linear and Generalized Linear Models. Wiley.
\item Faraway, F. (2016). Extending the Linear Model with R: Generalized Linear,
Mixed Effects and nonparametric regression models. Taylor & Francis, New York.
\item Fabio, L., Paula, G. A., and de Castro, M. (2012). A Poisson mixed model
with nonormal random effect distribution. Computational Statistics and
Data Analysis, 56, 1499-1510.
\item Fabio, L. C, Villegas, C. L., Carrasco, J. M. F. and de Castro, M. (2020). Diagnostic tools for a multivariate
negative binomial model for fitting correlated data with overdispersion. Submitted.
}
}
\author{
Jalmar M F Carrasco <carrascojalmar@gmail.com>,
Cristian M Villegas Lobos <master.villegas@gmail.com> and Lizandra C Fabio <lizandrafabio@gmail.com>
}
