% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateData.R
\name{GenerateData}
\alias{GenerateData}
\title{Generate random dataset}
\usage{
GenerateData(n, p, d, k = 3, theta = rdirichlet(1, rep(10, k)),
  psi = InitialPsi(p, d, k))
}
\arguments{
\item{n}{- number of samples}

\item{p}{- number of variables}

\item{d}{- a vector which denotes the number of categories for each variable. It could be distinct among variables.}

\item{k}{- number of latent classes}

\item{theta}{- probability for latent class}

\item{psi}{- probability for specific category}
}
\value{
data - generated random dataset, a matrix with n rows and p columns.
}
\description{
This function is used to generate random datasets following mixture of product multinomial distribution
}
\examples{
# dimension parameters
n<-200; p<-5; d<-rep(2,p);
# generate complete data
Complete<-GenerateData(n, p, d, k = 3)
}
