% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imputation.R
\name{Imputation}
\alias{Imputation}
\title{Imputation}
\usage{
Imputation(data, theta, psi, m, method = "Sampling")
}
\arguments{
\item{data}{- incomplete dataset}

\item{theta}{- a vector that sum to 1, denotes probability of latent class.}

\item{psi}{- an array with dimension c(k,p,d), specific probability for each variables in each component.}

\item{m}{- number of trials}

\item{method}{- methods for imputation, including Sampling and Expectation.}
}
\value{
CompleteData - dataset has been imputated.
}
\description{
This function is used to perform multiple imputation for missing data given the estimates of theta and psi.
}
\note{
k - number of components

n - number of observations

p - number of variables

d - number of choices. Here d are identical for all variables.
}
\examples{
data("IncompleteData")
theta <- IncompleteData$theta
psi <- IncompleteData$psi
Imputation(data = IncompleteData$data,theta,psi,m = 10,method = "Sampling")
}

