% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moicorrector.R
\name{corrector_numeric}
\alias{corrector_numeric}
\title{Removes punctuation characters and typos from data
entries}
\usage{
corrector_numeric(y, c_l, r_w, conm, cons, cha_num, rw_col, multsh)
}
\arguments{
\item{y}{string; a cell entry.}

\item{c_l}{string; marker label.}

\item{r_w}{numeric; sample ID's row number in the excel
file.}

\item{conm}{numeric; the multiple column per marker
identifier. For the data of format multiple columns
conm > 1.}

\item{cons}{numeric; the multiple row per sample
identifier. For the data of format multiple rows cons >
1.}

\item{cha_num}{string vector; the vector of punctuation
characters plus alphabets. See
\code{\link{moi_prerequisite}}.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}

\item{multsh}{string; reports warnings for multiple
worksheet datasets.}
}
\value{
a list of following elements: 1) a vector of
  lineages found on a microsatellite marker in a single
  cell. Each element corresponds to one and only one
  lineage and it is free from any punctuation character.
  2) an identifier whose value is 1 if a warning takes
  place.
}
\description{
This function is designed to find the
  lineages (STRs) present on a microsatellite marker in a
  single cell.
}
\seealso{
For further details see: \code{\link{moimport}},
  \code{\link{moi_marker}}.
}
\keyword{internal}
