% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{generate_interactive_plot}
\alias{generate_interactive_plot}
\title{Plot MIMS unit values or raw signal using dygraphs interactive plotting library.}
\usage{
generate_interactive_plot(df, y_label, value_cols = c(2, 3, 4))
}
\arguments{
\item{df}{data.frame.The dataframe storing MIMS unit values or raw
accelerometer signal. The first column should be timestamps.}

\item{y_label}{str. The label name to be put on the y axis.}

\item{value_cols}{numerical vector. The indices of columns storing values,
typically starting from the second column. The default is `c(2,3,4)`.}
}
\value{
A dygraphs graph object. When showing, the graph will be plotted in
  a html widgets in an opened browser.
}
\description{
\code{generate_interactive_plot} plots MIMS unit values or raw signal
  using dygraphs interactive plotting library.
}
\examples{
  # Use sample data for testing
  df = sample_raw_accel_data

  # Plot using default settings, due to pkgdown limitation, no interactive
  # plots will be shown on the website page.
  generate_interactive_plot(df,
                            y_label="Acceleration (g)")

  # The function can be used to plot MIMS unit values as well
  mims = mims_unit(df, dynamic_range=c(-8, 8))
  generate_interactive_plot(mims,
                            y_label="MIMS-unit values",
                            value_cols=c(2))
}
\seealso{
Other visualization functions.: 
\code{\link{illustrate_extrapolation}()},
\code{\link{illustrate_signal}()}
}
\concept{visualization functions.}
