% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{cut_off_signal}
\alias{cut_off_signal}
\title{Cut off input multi-channel signal according to a new dynamic range}
\usage{
cut_off_signal(df, range = NULL, noise_std = 0.03)
}
\arguments{
\item{df}{dataframe. Input multi-channel accelerometer data.}

\item{range}{numerical vector. The new dynamic ranges to cut off the signal.
Should be a 2-element numerical vector. \code{c(low, high)}, where
\code{low} is the negative max value the device can reach and \code{high}
is the positive max value the device can reach. Default is \code{NULL},
meaning the function will do nothing but return the input data.}

\item{noise_std}{number. The standard deviation of the added gaussian noise.}
}
\value{
dataframe. The multi-channel accelerometer data with the new dynamic
  range as specified in \code{range}.
}
\description{
\code{cut_off_signal} cuts off the input multi-channel accelerometer data
according to a new dynamic range, then adds gausian noise to the cut-off
samples.
}
\details{
This function simulates the behavior that a low dynamic range device is
trying to record high intensity movement, where recorded accelerometer signal
will be cut off at the dynamic range, but the true movement should have
higher acceleration values than the dynamic range. This function also adds
gaussian noise to the cut off samples to better simulate the real world
situation.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a utility
  function that is used to simulate the behaviors of low dynamic range
  devices during algorithm validation.
}

\examples{
  # Use sample data for testing
  df = sample_raw_accel_data

  # Show df
  illustrate_signal(df, range=c(-8, 8))

  # cut off the signal to c(-2, 2)
  new_df = cut_off_signal(df, range=c(-2, 2), noise_std=0.03)

  # Show new df
  illustrate_signal(new_df, range=c(-2, 2))
}
\seealso{
Other utility functions: 
\code{\link{clip_data}()},
\code{\link{interpolate_signal}()},
\code{\link{parse_epoch_string}()},
\code{\link{sampling_rate}()},
\code{\link{segment_data}()},
\code{\link{simulate_new_data}()}
}
\concept{utility functions}
