% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miivs.R
\name{miivs}
\alias{miivs}
\title{Model-implied instrumental variable (MIIV) search}
\usage{
miivs(model)
}
\arguments{
\item{model}{A model specified using lavaan model syntax. See the 
\code{model} argument within the \code{\link[lavaan]{lavaanify}} 
function for more information. See the documentation below for a 
description of how to specify the scaling  indicator in latent 
variable models and impose equality constraints on the parameter 
estimates.}
}
\value{
A list of model equations.
}
\description{
A key step in the MIIV-2SLS approach is to transform the SEM by 
replacing the latent variables with their scaling indicators 
minus their errors.  Upon substitution the SEM is transformed 
from a model with latent variables to one containing observed 
variables with composite errors. The miivs function 
automatically makes this transformation. The miivs function
will also identify equation-specific model-implied 
instrumental variables in simultaneous equation models
without latent variables.
}
\details{
\itemize{
\item{\code{model}} {

  A model specified using the model syntax employed by \pkg{lavaan}. 
  The following model syntax operators are currently supported: =~,
  ~, ~~ and *. See below for details on default behaviors, 
  how to specify the scaling indicator in latent variable models, 
  and how to impose equality constraints on the parameter estimates. 
  
  \strong{Example using Syntax Operators}
  
  In the model below, 'L1 =~ Z1 + Z2 + Z3'  indicates the 
  latent variable L1 is measured by 3 indicators, Z1, Z2, and Z3. Likewise,
  L2 is measured by 3 indicators, Z4, Z5, and Z6. The statement
  'L1 ~ L2' specifies latent variable L1 is regressed on latent 
  variable L2. 'Z1 ~~ Z2' indicates the error of Z2 is allowed to 
  covary with the error of Z3. The label
  LA3 appended to Z3 and Z6 in the measurement model equations 
  constrains the factor loadings for Z3 and Z6 to equality. For 
  additional details on constraints see Equality Constraints 
  and Parameter Restrictions.
  
  \preformatted{model <- '
     L1 =~ Z1 + Z2 + LA3*Z3
     L2 =~ Z4 + Z5 + LA3*Z6
     L1  ~ L2
     Z2 ~~ Z3
  '}
 
  \strong{Scaling Indicators}
  
  Following the \pkg{lavaan} model syntax, latent variables are defined 
  using the \code{=~} operator.  For first order factors, the scaling 
  indicator chosen is the first observed variable on the RHS of an 
  equation. For the model  below \code{Z1} would be chosen as the 
  scaling indicator for \code{L1} and \code{Z4} would be chosen as 
  the scaling indicator for \code{L2}.
  
  \preformatted{model <- '
     L1 =~ Z1 + Z2 + Z3
     L2 =~ Z4 + Z5 + Z6
  '}
  
  
  \strong{Equality Constraints and Parameter Restrictions}
  
  Within- and across-equation equality constraints on the factor loading
  and regression coefficients can be imposed directly in the model syntax. 
  To specify equality constraints between different parameters equivalent
  labels should be prepended to the variable name using the 
  * operator. For example, we could constrain the factor 
  loadings for two non-scaling indicators of latent factor \code{L1} to 
  equality using the following  model syntax.
  
  \preformatted{model <- '
     L1 =~ Z1 + LA2*Z2 + LA2*Z3
     L2 =~ Z4 + Z5 + Z6
  '}
  
  Researchers can also constrain the factor loadings and regression 
  coefficients to specific numeric values in a similar fashion. Below 
  we constrain the regression coefficient  of \code{L1} on \code{L2} 
  to \code{1}.
  
  \preformatted{model <- '
     L1 =~ Z1 + Z2 + Z3
     L2 =~ Z4 + Z5 + Z6
     L3 =~ Z7 + Z8 + Z9
     L1  ~ 1*L2 + L3
  '}

  \strong{Higher-order Factor Models}
  
  For example, in the model below, the  scaling indicator for the 
  higher-order factor \code{H1} is taken to be \code{Z1}, the scaling 
  indicator that would have been assigned to the first lower-order 
  factor \code{L1}. The intercepts for lower-order latent variables 
  are set to zero, by default
  
  \preformatted{model <- '
     H1 =~ L1 + L2 + L3
     L1 =~ Z1 + Z2 + Z3
     L2 =~ Z4 + Z5 + Z6
     L3 =~ Z7 + Z8 + Z9
  '}
  
  \strong{Model Defaults}
  
  In addition to those relationships specified in the model syntax 
  \pkg{MIIVsem} will automatically include the intercepts of any 
  observed or latent endogenous variable. The intercepts
  for any scaling indicators and lower-order latent variables are
  set to zero. Covariances among exogenous latent
  and observed  variables are included by default when \code{
  var.cov = TRUE}. Where appropriate the covariances of the errors
  of latent and observed dependent variables are also automatically 
  included in the model specification. These defaults correspond 
  to those used by \pkg{lavaan} and \code{auto = TRUE}, except that 
  endogenous latent variable intercepts are estimated by default, 
  and the intercepts of scaling indicators are fixed to zero.
  
  \strong{Invalid Specifications}
  
  Certain model specifications are not currently supported.  For example,
  the scaling indicator of a latent variable is not permitted to
  cross-load on another latent variable. In the model below
  \code{Z1}, the scaling indicator for L1, cross-loads on the latent 
  variable \code{L2}. Executing a search on the model below will 
  result in the warning: \emph{miivs: scaling indicators with a factor 
  complexity greater than 1 are not currently supported}.
  
  \preformatted{model <- '
    L1 =~ Z1 + Z2 + Z3
    L2 =~ Z4 + Z5 + Z6 + Z1
  '}
  
  In addition, \pkg{MIIVsem} does not currently support relations
  where the scaling indicator of a latent variable is also the 
  dependent variable in a regression equation.  For example, the
  model below would not be valid under the current algorithm.
  
  \preformatted{model <- '
    L1 =~ Z1 + Z2 + Z3
    Z1  ~ Z4
    Z4  ~ Z5 + Z6
  '}
   
  
  }
}

The \code{miivs} function displays a table containing the following 
information for each equation in the system:

\itemize{
 \item \code{LHS} The "dependent" variable.
 \item \code{RHS} The right hand side variables of the transformed equation.
 \item \code{MIIVs} The model-implied instrumental variables for each equation.
}
}
\examples{
bollen1989a_model <- '

    Eta1 =~ y1 + y2  + y3  + y4  
    Eta2 =~ y5 + y6  + y7  + y8    
    Xi1  =~ x1 + x2 + x3 

    Eta1 ~ Xi1  
    Eta2 ~ Xi1 
    Eta2 ~ Eta1 

    y1   ~~ y5
    y2   ~~ y4
    y2   ~~ y6
    y3   ~~ y7
    y4   ~~ y8
    y6   ~~ y8 
  '

miivs(bollen1989a_model)
}
\references{
Bollen, K. A. (1996).	An	Alternative	2SLS Estimator	for	Latent	
Variable	Models.	\emph{Psychometrika}, 61, 109-121.

Bentler, P. M., and Weeks, D. G. (1980). Linear Structural 
Equations with Latent Variables. \emph{Psychometrika}, 45, 289–308.
}
\seealso{
\code{\link{miive}}
}
