% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbern.R
\name{bbern}
\alias{bbern}
\title{Bayesian analysis of generalized mixed linear model using MCMC}
\usage{
bbern(m, n, nc, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{nc}{number of MCMC chains}

\item{data}{dataset with entries 0,1. column names are age,grp(group),gen(gender),0,1,2,3,4 (time points)}
}
\value{
posterior distribution results of parameters.
}
\description{
Provides bayesian analysis of generalized mixed linear model where the repeated measure(with missing value) follows bernoulli distrbution
using MCMC
}
\details{
The model for the response variable is given by
\deqn{Y_{ij}\sim Bernoulli(\mu_{ij})}
where link function is
\deqn{logit(\mu_{ij})=\beta_1+\beta_2 t_j+\beta_3 t_{j}^2+\beta_4 age_{i}+\beta_{5}gen_{i}
\beta_{6}grp_{i}+b_{1i}}
where i is the ith individual and j is the timepoint.
}
\examples{
##
data(catadata)
bbern(m=1,n=3,nc=1,data=catadata)
##
}
\references{
Broemeling, Lyle D. Bayesian methods for repeated measures. CRC Press, 2015.
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
