% Generated by roxygen2 (4.0.1): do not edit by hand
\name{MI.ci}
\alias{MI.ci}
\title{Cumulative incidence estimation for interval censored competing risks data using multiple imputation}
\usage{
MI.ci(k, m, data, status, trans, cens.code, conf.int = F, alpha = 0.05)
}
\arguments{
\item{k}{An integer, indicates the number of iteration to perform}

\item{m}{An integer, indicates the number of imputation to perform at each iteration}

\item{status}{The name of the column where status are to be found}

\item{trans}{Denomination of the event of interest in the status column}

\item{data}{The input data (see details)}

\item{conf.int}{Logical, computes the confidence interval}

\item{cens.code}{Censor indicator in the status column of the data}

\item{alpha}{Parametrize the confidence interval width}
}
\value{
\code{est} A data frame with estimates

\code{\dots} Other objects
}
\description{
Uses multiple imputation to compute the cumulative incidence function for interval censored competing risks data
}
\details{


This function uses a multiple imputation approach to estimate a cumulative incidence function for interval censored competing
 risks data.
 Estimates are computed using Rubin's rules (Rubin (1987)). The cumulative incidence is computed as the mean of
 cumulative incidences over imputations. The variance is computed at each point by combining the within imputation variance and the
 between imputation variance augmented by an inflation factor to take into account the finite number of imputations.
 At each iteration, the cumulative incidence is updated and multiple imputation is performed using the updated estimate.
 If \code{conf.int} is required, the log-log transformation is used to compute the lower confidence interval.

 Print and plot methods are available to handle results.

 The \code{data} must contain at last three columns: \code{left}, \code{right} and \code{status}. For interval censored data, the
 \code{left} and \code{right} columns indicates lower and upper bounds of intervals, respectively. \code{Inf} in the
 \code{right} column stands for right censored observations. When an observation is right censored, the \code{status} column must
 contain the censor indicator specified by \code{cens.code}. The transition of interest must be specified by the \code{trans}
 parameter.
}
\examples{
res <- MI.ci(k = 5,  m = 5, status = 'status',  trans = 1 , data = ICCRD,
 conf.int = TRUE, cens.code = 0 , alpha = 0.05)
 res
 print(res)
 plot(res)
}
\author{
Marc Delord \email{<mdelord@gmail.com>}
}
\references{
Delord, M. & Genin, E. Multiple Imputation for Competing Risks Regression with Interval Censored Data Journal of Statistical
 Computation and Simulation, 2015

PAN, Wei. A Multiple Imputation Approach to Cox Regression with Interval-Censored Data. Biometrics, 2000, vol. 56, no 1,
  p. 199-203.

Rubin, D. B. (1987). Multiple imputation for nonresponse in surveys.

Schenker, N. and Welsh, A. (1988). Asymptotic results for multiple imputation. The Annals of Statistics pages 1550-1566.

Tanner, M. A. and Wong, W. H. (1987). An application of imputation to an estimation problem in grouped lifetime analysis.
 Technometrics 29, 23-32.

Wei, G. C., & Tanner, M. A. (1991). Applications of multiple imputation to the analysis of censored regression data.
 Biometrics, 47(4), 1297-1309.
}
\seealso{
\link[survival]{Surv}, \link[survival]{survfit}
}

