% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/MI.surv.R
\name{MI.surv}
\alias{MI.surv}
\title{Survival estimation for interval censored data using multiple imputation}
\usage{
MI.surv(m, data, conf.int = TRUE, alpha = 0.05)
}
\arguments{
\item{m}{An integer, indicates the number of imputation to perform at each iteration}

\item{data}{The input data (see details)}

\item{conf.int}{Logical, computes the confidence interval}

\item{alpha}{Parametrize the confidence interval width}
}
\value{
\code{est} A data frame with estimates
}
\description{
Uses multiple imputation to compute the survival function with interval censored data
}
\details{


This function uses the multiple imputation aproach to estimate the survival function for interval censored data.

 Estimates arecomputed using Rubin's rules (Rubin (1987)). Survival function estimate is computed as the mean of survival over
 imputations. The variance is computed at each point by combining the within imputation variance and the between imputation variance
 augmented by an inflation factor to take into account the finite number of imputation. If \code{conf.inf} is required, the log-log
 transformation is used to compute the lower confidence interval.

 Print and plot methods are available to handle results.

 The \code{data} must contain at last two columns: \code{left} and \code{right}. For interval censored data, the \code{left} and the
 \code{right} columns indicates lower and upper bounds of intervals respectively. \code{Inf} in the \code{right} column stands
 for right censored observations.
}
\examples{
res<-MI.surv( m = 10 , data = ICCRD , conf.int = TRUE )
  res
  plot( res )
  #plot( res , fun = 'event')
}
\author{
Marc Delord \email{<mdelord@gmail.com>}
}
\references{
PAN, Wei. A Multiple Imputation Approach to Cox Regression with Interval-Censored Data. Biometrics, 2000, vol. 56, no 1,
  p. 199-203.

Rubin, D. B. (1987). Multiple imputation for nonresponse in surveys.

Schenker, N. and Welsh, A. (1988). Asymptotic results for multiple imputation. The Annals of Statistics pages 1550-1566.

Tanner, M. A. and Wong, W. H. (1987). An application of imputation to an estimation problem in grouped lifetime analysis.
 Technometrics 29, 23-32.

Wei, G. C., & Tanner, M. A. (1991). Applications of multiple imputation to the analysis of censored regression data.
 Biometrics, 47(4), 1297-1309.
}
\seealso{
\link[survival]{Surv}, \link[survival]{survfit}
}

