% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patric.R
\name{tidy_patric_meta_data}
\alias{tidy_patric_meta_data}
\title{Tidy PATRIC data}
\usage{
tidy_patric_meta_data(
  x,
  prefer_more_resistant = TRUE,
  as_ab = TRUE,
  filter_abx = NULL
)
}
\arguments{
\item{x}{PATRIC database loaded using MIC::load_patric_db}

\item{prefer_more_resistant}{High MICs, narrow zones, or resistant phenotypes
will be preferred where multiple reported for the same isolate}

\item{as_ab}{convert antibiotics to AMR::ab class (column names are antibiotic
codes)}

\item{filter_abx}{filter antibiotics of interest, provided as a vector of
antibiotics character names/codes, or ideally, as AMR::ab classes, created
using AMR::as.ab}
}
\value{
Tidy data, with antimicrobials in wide format, column names describing
methodology ("mic_", "disk_", "pheno_"). S3 class "tidy_patric_db".
}
\description{
Tidy PATRIC data
}
\examples{
db <- data.frame(genome_id = 1,
                genome_name = "E. coli",
                antibiotic = "amoxicillin",
                measurement = 2.0,
                measurement_unit = "mg/L",
                laboratory_typing_method = "Agar dilution",
                resistant_phenotype = "R")
db <- load_patric_db(db)
tidy_patric_meta_data(db)
}
