% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_data.R
\name{bias}
\alias{bias}
\title{Calculate MIC bias}
\usage{
bias(gold_standard, test)
}
\arguments{
\item{gold_standard}{AMR::mic vector}

\item{test}{AMR::mic vector}
}
\value{
numeric value
}
\description{
Calculate the bias between two AMR::mic vectors. The bias is calculated as
the percentage of test MICs that are above the gold standard MICs minus the
percentage of test MICs that are below the gold standard MICs.
}
\examples{
gold_standard <- c("<0.25", "8", "64", ">64")
test <- c("<0.25", "2", "16", "64")
bias(gold_standard, test)
}
\references{
International Organization for Standardization. ISO 20776-2:2021
Available from: https://www.iso.org/standard/79377.html
}
