% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHMM.R
\name{mhmm}
\alias{mhmm}
\title{Mixture model of Hidden Markov Models.}
\usage{
mhmm(y, K, M, smartinit = TRUE, nbinit = 100, tol = 10^(-4),
  nbKeep = min(20, nbinit), iterSmall = 10, nbcores = 1)
}
\arguments{
\item{y}{list. Observations (one element of the list per subject, missing values should be encoded by NA).}

\item{K}{numeric. Number of mixture components.}

\item{M}{numeric. Number of states.}

\item{smartinit}{boolean. If TRUE, MLE of the mixture neglecting the time dependency is used for the initialization of the algorithm.}

\item{nbinit}{numeric.Number of initializations.}

\item{tol}{numeric. It indicates the maximal gap between two successive iterations of EM algorithm which stops the algorithm}

\item{nbKeep}{numeric. It indicates the number of chains used for the final EM algorithm}

\item{iterSmall}{numeric. It indicates  the number of iterations for each SmallEM algorithm}

\item{nbcores}{numeric.  It defines the numerber of cores used by the algorithme}
}
\value{
Returns an instance of \linkS4class{mhmmresults}.
}
\description{
This function performs maximum likelihood inference of mixture of hidden Markov models
}
\examples{
data(accelero)
# To make the estimation <5
res <- mhmm(accelero, K = 2, M = 4, nbcores = 1, nbinit = 5, iterSmall = 2)
plot(res, 1)

 \donttest{
data(accelero)
# It is better to increase the number of random initializations
res <- mhmm(accelero, K = 2, M = 4, nbcores = 1)
plot(res, 1)
}

}
\references{
Du Roy de Chaumaray, M. and Marbac, M. and Navarro, F. (2019). Mixture of hidden Markov models for accelerometer data. arXiv preprint arXiv:1906.01547
}
