% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateFas_func_20170924.R
\name{CreateFas}
\alias{CreateFas}
\title{CreateFas() function}
\usage{
CreateFas(seq_table, path_out)
}
\arguments{
\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
A FASTA file with all the sequences in a 'dada2' sequence table. The
  sequences are named in the FASTA file by an index number corresponding to
  their column number in the sequence table.
}
\description{
\code{\link{CreateFas}} creates a FASTA file with all the sequences in a
'dada2' sequence table.
}
\details{
If you publish data produced with MHCtools, please cite:
Roved, J. 2020. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., Westerdahl, H. 2020.
Non-random association of MHC-I alleles in favor of high diversity haplotypes
in wild songbirds revealed by computer-assisted MHC haplotype inference using
the R package MHCtools. bioRxiv.
}
\examples{
seq_table <- sequence_table_fas
path_out <- tempdir()
CreateFas(seq_table, path_out)
}
\seealso{
\code{\link{CreateSamplesFas}}; for more information about 'dada2'
  visit <https://benjjneb.github.io/dada2/>
}
