% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-analysis.R
\name{split_aggregate_CSV}
\alias{split_aggregate_CSV}
\title{Split CSV output by Patch and Aggregate by Mate or Dwell-Stage}
\usage{
split_aggregate_CSV(
  read_dir,
  write_dir = read_dir,
  stage = c("E", "L", "P", "M", "U", "FS", "FE", "FI", "H"),
  spn_P,
  tmax,
  dt,
  erlang = FALSE,
  sum_fem = FALSE,
  rem_file = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{read_dir}{Directory where output was written to}

\item{write_dir}{Directory to write output to. Default is read_dir}

\item{stage}{Life stage to print, see details}

\item{spn_P}{Places object, see details}

\item{tmax}{The final time to end simulation}

\item{dt}{The time-step at which to return output (\strong{not} the time-step of the sampling algorithm)}

\item{erlang}{Boolean, default is FALSE, to return summaries by genotype}

\item{sum_fem}{if \code{TRUE}, in addition to FS, FE, FI output by node and repetition, output an
additional file F which sums over infection states (S,E,I). Does nothing if the
simulation did not include epi dynamics.}

\item{rem_file}{Remove original output? Default is FALSE}

\item{verbose}{Chatty? Default is TRUE}
}
\value{
Writes output to files in write_dir
}
\description{
This function reads in the output files from \code{\link{sim_trajectory_CSV}}
and splits them into smaller files. The files are output by patch, with the
appropriate patch numbers for mosquitoes or humans, and specific stages are
aggregated by a given metric. \cr
}
\details{
Given the \code{read_dir}, this function assumes the follow file structure: \cr
\itemize{
\item read_dir
\itemize{
\item repetition 1
\itemize{
\item M.csv
\item FS.csv
\item ... \cr
}
\item repetition 2
\itemize{
\item M.csv
\item FS.csv
\item ... \cr
}
\item repetition 3
\item ... \cr
}
}

This function expects the \code{write_dir} to be empty, and it sets up the
same file structure as the \code{read_dir}. For a 2-node simulation, the output
will be organized similar to: \cr
\itemize{
\item write_dir
\itemize{
\item repetition 1
\itemize{
\item M_0001.csv
\item M_0002.csv
\item FS_0001.csv
\item FS_0001.csv
\item ... \cr
}
\item repetition 2
\itemize{
\item M_0001.csv
\item M_0002.csv
\item FS_0001.csv
\item FS_0001.csv
\item ... \cr
}
\item repetition 3
\item ... \cr
}
}

\code{stage} defines which life-stages the function will analyze. These stages
must be any combination of: "E", "L", "P", "M", "U", "FS", "FE", "FI", "H".
These must come from the set of stages provided to \code{\link{sim_trajectory_CSV}}
via the \code{stage} argument. It can be less than what was printed by the simulation,
but any extra stages provided, but not printed, will throw a warning and then
be ignored.

\code{erlang} defines how aquatic (eggs, larvae, and pupae) stages and adult females
(only mated females) are aggregated. By default, \code{erlang} is FALSE, and
all of these stages are summarized by genotype only, combining any Erlang-distributed
dwell stages (for eggs, larvae, and pupae) or latent infection (for adult females)
stages. If \code{erlang} is TRUE, summaries are returned by dwell stage or infection
status, combining any genotype information. \cr
Female summaries always combine over mate-genotype, so only female genotypes
are returned.

The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

\code{tmax}, \code{dt} define the last sampling
time, and each sampling time in-between.

For more details about using this function to process CSV output see:
\code{vignette("data-analysis", package = "MGDrivE2")}
}
