% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-RecTrans.R
\name{cubeReciprocalTranslocations}
\alias{cubeReciprocalTranslocations}
\title{Inheritance Cube: Reciprocal Translocation}
\usage{
cubeReciprocalTranslocations(eta = NULL, phi = NULL, omega = NULL,
  xiF = NULL, xiM = NULL, s = NULL)
}
\arguments{
\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model a reciprocal translocation.
This technology was the original form of underdominant system. It involves 2
chromosomes, each with two alleles. \cr
This drive has 4 alleles at 2 loci:
\itemize{
\item a: Wild-type at locus A
\item A: Translocation at locus A
\item b: Wile-type at locus B
\item B: Translocation at locus B
}
}
