% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata3.R
\name{gendata3}
\alias{gendata3}
\title{Generate simulation data (Categorial data)}
\usage{
gendata3(n, p, rho)
}
\arguments{
\item{n}{Number of subjects in the dataset to be simulated. It will also equal to the
number of rows in the dataset to be simulated, because it is assumed that each
row represents a different independent and identically distributed subject.}

\item{p}{Number of predictor variables (covariates) in the simulated dataset.
These covariates will be the features screened by model-free procedures.}

\item{rho}{The correlation between adjacent covariates in the simulated matrix X.
The within-subject covariance matrix of X is assumed to has the same form as an
AR(1) auto-regressive covariance matrix, although this is not meant to imply
that the X covariates for each subject are in fact a time series. Instead, it is just
used as an example of a parsimonious but nontrivial covariance structure. If
rho is left at the default of zero, the X covariates will be independent and the
simulation will run faster.}
}
\value{
the list of your simulation data
}
\description{
This function helps you quickly generate simulation data based on logistic model.
You just need to input the sample and dimension of the data
you want to generate and the covariance parameter pho.
}
\examples{
n=100;
p=200;
pho=0.5;
data=gendata3(n,p,pho)
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
