% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateExpansions.R
\name{splineFunction1D}
\alias{splineFunction1D}
\title{Calculate linear combinations of spline basis functions on one-dimensional 
domains}
\usage{
splineFunction1D(scores, argvals, bs, m, k)
}
\arguments{
\item{scores}{A matrix of dimension \code{N x K}, representing the \code{K} 
scores (coefficients) for each of the \code{N} observations.}

\item{argvals}{A list containing a vector of x-values, on which the functions
should be defined.}

\item{bs}{A character string, specifying the type of basis functions to be 
used. Please refer to \code{\link[mgcv]{smooth.terms}} for a list of 
possible basis functions.}

\item{m}{A numeric, the order of the spline basis. See  \code{\link[mgcv]{s}}
for details.}

\item{k}{A numeric, the number of basis functions used. See 
\code{\link[mgcv]{s}} for details.}
}
\value{
An object of class \code{funData} with \code{N} observations on 
  \code{argvals}, corresponding to the linear combination of spline basis 
  functions.
}
\description{
Given scores (coefficients), this function calculates a linear combination of
spline basis functions on one-dimensional domains based on the 
\link[mgcv]{gam} function in the \pkg{mgcv} package.
}
\seealso{
\code{\link{univExpansion}}, \code{\link{gam}},
  \code{\link{splineBasis1D}}
}
\keyword{internal}
