% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_stability_selection.R
\name{MFKnockoffs.stat.stability_selection}
\alias{MFKnockoffs.stat.stability_selection}
\title{Stability selection statistics for MFKnockoffs}
\usage{
MFKnockoffs.stat.stability_selection(X, X_k, y, fitfun = stabs::glmnet.lasso,
  ...)
}
\arguments{
\item{X}{original design matrix (size n-by-p)}

\item{X_k}{knockoff matrix (size n-by-p)}

\item{y}{response vector (length n)}

\item{fitfun}{fitfun a function that takes the arguments x, y as above, 
and additionally the number of variables to include in each model q. 
The function then needs to fit the model and to return a logical vector 
that indicates which variable was selected (among the q selected variables).
The name of the function should be prefixed by 'stabs::'.}

\item{...}{additional arguments specific to 'stabs' (see Details)}
}
\value{
A vector of statistics \eqn{W} (length p)
}
\description{
Computes the difference statistic
  \deqn{W_j = |Z_j| - |\tilde{Z}_j|}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are measure the importance
of the jth variable and its knockoff, respectively, based on the 
stability of their selection upon subsampling of the data.
}
\details{
This function uses the \code{stabs} package to compute
variable selection stability. The selection stability of the j-th 
variable is defined as its probability of being selected upon random
subsampling of the data. The default method for selecting variables 
in each subsampled dataset is \code{stabs::glmnet.lasso_maxCoef}.

For a complete list of the available additional arguments, see \link[stabs]{stabsel}.
}
\examples{
p=100; n=200; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)

knockoffs = function(X) MFKnockoffs.create.gaussian(X, mu, Sigma)
# Basic usage with default arguments
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs,
                           statistic=MFKnockoffs.stat.stability_selection)
print(result$selected)

# Advanced usage with custom arguments
foo = MFKnockoffs.stat.stability_selection
k_stat = function(X, X_k, y) foo(X, X_k, y, fitfun=stabs::lars.lasso)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics for knockoffs: \code{\link{MFKnockoffs.stat.forward_selection}},
  \code{\link{MFKnockoffs.stat.glmnet_coef_difference}},
  \code{\link{MFKnockoffs.stat.glmnet_lambda_difference}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference}},
  \code{\link{MFKnockoffs.stat.random_forest}},
  \code{\link{MFKnockoffs.stat.sqrt_lasso}}
}
