% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_table}
\alias{expand_table}
\title{Expand table or matrix to data frame}
\usage{
expand_table(x)
}
\arguments{
\item{x}{A table or matrix}
}
\value{
A data frame with the table or matrix expanded
}
\description{
Expands a contingency table to a data frame where each observation in the table becomes a single observation in the data frame with corresponding information for each for each combination of the table dimensions.
}
\examples{

expand_table(diag(3))
m <- matrix(c(2, 1, 3, 0, 0, 2), 3)
expand_table(m)
result <- expand_table(UCBAdmissions)
head(result)

# Combine into table again
xtabs(~Admit + Gender + Dept, data=result)

}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{manip}
