% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CondBED.R
\name{CondBED}
\alias{CondBED}
\title{Conditional distribution of Y given X=x of the bivariate exponential distribution (BED)
based on the Moran-Downton model}
\usage{
CondBED(rho,Betax,Betay,x)
}
\arguments{
\item{rho}{Correlation coefficient between the marginal distributions of x and y.}

\item{Betax}{Scale parameter of the marginal distribution of x.}

\item{Betay}{Scale parameter of the marginal distribution of y.}

\item{x}{a value or vector of values of the marginal distribution of x.}
}
\value{
A list with a dataframe, named Conditional_Statistics, and a sublist, named Condyx, is provided.
        Conditional_Statistics contains the values of x with its conditional moments, and Condyx contains
        several dataframes with the values of the conditional PDF and CDF of each conditional distribution
        associated to each value of x. For each conditional distribution, the values of the conditional
        quantiles (yc) with its respective density values (fyx) and its associated cumulative conditional probability values (Fyx) are
        provided.The first dataframe of Condyx corresponds to the first value of x shown in Conditional_Statistics,
        the second dataframe corresponds to the second value of x shown in Conditional_Statistics and so on.
}
\description{
This function computes the conditional PDF and CDF of Y given X=x of the BED
based on the equations of the conditional moments of the Moran-Downton model.
}
\details{
This function computes the conditional PDF and CDF of Y given X=x. The conditional density is
computed based on the conditional moments of the Moran-Downton model described in Eqs. 21 and 22 in \insertCite{Nagao1971;textual}{MDBED}.
The conditional CDF is computed via numerical integration of the conditional PDF based on the Riemann sum method.
}
\examples{
Data<-rBED(n=50,Betax=1,Betay=1,rho=0.85)
Conyx<-CondBED(rho=0.85,Betax=1,Betay=1,x=Data[,1])
}
\references{
\insertAllCited{}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
