% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MCSprocedure}
\alias{MCSprocedure}
\title{MCSprocedure}
\usage{
MCSprocedure(Loss, alpha = 0.15, B = 5000, cl = NULL,
  ram.allocation = T, statistic = "Tmax", k = NULL, min.k = 3,
  verbose = T)
}
\arguments{
\item{Loss}{A matrix or something coercible to that (as.matrix) which contains the loss series per each competing model}

\item{alpha}{a scalar in (0,1) indicating the confidence level of the tests}

\item{B}{an integer indicating the number of bootstrapped samples used to construct the statistic test}

\item{cl}{A cl object created by calling makecl from the parallel package. If it is not NULL, then this will be used for parallel processing (remember to stop the cl on completion)}

\item{ram.allocation}{Default TRUE, only considered if cl in not NULL. Let the function decide how to allocate memory when cl are supplied ? Usefull when many models are available.}

\item{statistic}{Possible choice are : Tmax and TR. See Hansen et.al. (2011) [pag. 465] and Bernardi M. and Catania L. (2014) for more information.}

\item{k}{The number of block bootstrap length. If NULL (default) the block length is determined by the max number of significants parameters resulted after fitting an AR(p) process on all the Loss differences as suggested by Hansen et.al. (2011)}

\item{min.k}{If k=NULL the minimum length of the the blocks, by default equal to 3}

\item{verbose}{Information abount the MCS procedure should be printed ?}
}
\value{
A SSM object
}
\description{
Perform the Model Confidence Set procedure of Hansen et.al. (2011)
}
\author{
Leopoldo Catania & Mauro Bernardi
}
\references{
Hansen PR, Lunde A, Nason JM (2011). The model confidence set. Econometrica, 79(2), 453-497.

Bernardi M. and Catania L. (2014) The Model Confidence Set package for R. URL \url{http://arxiv.org/abs/1410.8504}
}
\examples{
\dontrun{
library(MCS)
data(Loss)
MCS <- MCSprocedure(Loss=Loss[,1:5],alpha=0.2,B=5000,statistic='Tmax',cl=NULL)
}
}
