% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCPModGen.R
\name{MCPModGen}
\alias{MCPModGen}
\title{MCPModGen - Multiple Comparison and Modeling (General Case)}
\usage{
MCPModGen(
  family = c("negative binomial", "binomial"),
  link = c("log", "logit", "probit", "cauchit", "cloglog", "identity", "log risk ratio",
    "risk ratio"),
  returnS = FALSE,
  w = NULL,
  dose,
  resp,
  data = NULL,
  models,
  addCovars = ~1,
  placAdj = FALSE,
  selModel = c("AIC", "maxT", "aveAIC"),
  alpha = 0.025,
  df = NULL,
  critV = NULL,
  doseType = c("TD", "ED"),
  Delta,
  p,
  pVal = TRUE,
  alternative = c("one.sided", "two.sided"),
  na.action = na.fail,
  mvtcontrol = mvtnorm.control(),
  bnds,
  control = NULL,
  offset = NULL,
  ...
)
}
\arguments{
\item{family}{A character string containing the error distribution to be used
in the model.}

\item{link}{A character string for the model link function.}

\item{returnS}{Logical determining whether muHat and SHat should be returned,
in additional to the MCPMod output.}

\item{w}{Either a numeric vector of the same length as dose and resp, or a
character vector denoting the column name in the data.}

\item{dose, resp}{Either vectors of equal length specifying dose and response
values, or character vectors specifying the names of variables in the data
frame specified in \code{data}.}

\item{data}{Data frame with names specified in `dose`, `resp`, and optionally
`w`. If data is not specified, it is assumed that `dose` and `resp` are
numerical vectors}

\item{models}{
    An object of class \samp{"Mods"}, see \code{\link[DoseFinding]{Mods}} for
    details
  }

\item{addCovars}{Formula specifying additive linear covariates (e.g. `~
factor(gender)`).}

\item{placAdj}{Logical specifying whether the provided by `resp` are to be
treated as placebo-adjusted estimates.}

\item{selModel}{
  Optional character vector specifying the model selection criterion for
  dose estimation.  Possible values are 
  \itemize{
    \item \code{AIC}: Selects model with smallest AIC (this is the default)
    \item \code{maxT}: Selects the model corresponding to the largest t-statistic.
    \item \code{aveAIC}: Uses a weighted average of the models corresponding to the
    significant contrasts.  The model weights are chosen by the formula:
    \eqn{w_i = \exp(-0.5AIC_i)/\sum_i(\exp(-0.5AIC_i))}{w_i = exp(-0.5AIC_i)/sum(exp(-0.5AIC_i))}
    See Buckland et al. (1997) for details.
  }
  For \samp{type = "general"} the "gAIC" is used.

}

\item{alpha}{
    Significance level for the multiple contrast test
}

\item{df}{An optional numeric value specifying the degrees of freedom.
Infinite degrees of freedom (`df=Inf`, the default), correspond to the
multivariate normal distribution.}

\item{critV}{
  Supply a pre-calculated critical value. If this argument is NULL, no
  critical value will be calculated and the test decision is based on
  the p-values. If \samp{critV = TRUE} the critical value will be calculated. 
}

\item{doseType}{
    \samp{doseType} determines the dose to estimate, ED or TD (see also
    \code{\link[DoseFinding]{Mods}}), and \samp{Delta} and \samp{p} need to be
    specified depending on whether TD or ED is to be estimated.
    See \code{\link[DoseFinding]{TD}} and \code{\link[DoseFinding]{ED}} for details.
  }

\item{Delta}{
    \samp{doseType} determines the dose to estimate, ED or TD (see also
    \code{\link[DoseFinding]{Mods}}), and \samp{Delta} and \samp{p} need to be
    specified depending on whether TD or ED is to be estimated.
    See \code{\link[DoseFinding]{TD}} and \code{\link[DoseFinding]{ED}} for details.
  }

\item{p}{
    \samp{doseType} determines the dose to estimate, ED or TD (see also
    \code{\link[DoseFinding]{Mods}}), and \samp{Delta} and \samp{p} need to be
    specified depending on whether TD or ED is to be estimated.
    See \code{\link[DoseFinding]{TD}} and \code{\link[DoseFinding]{ED}} for details.
  }

\item{pVal}{
    Logical determining, whether p-values should be calculated.
}

\item{alternative}{
  Character determining the alternative for the multiple contrast
  trend test. 
}

\item{na.action}{
  A function which indicates what should happen when
  the data contain NAs.
}

\item{mvtcontrol}{
  A list specifying additional control parameters for the \samp{qmvt}
  and \samp{pmvt} calls in the code, see also \code{\link[DoseFinding]{mvtnorm.control}}
  for details.
}

\item{bnds}{
  Bounds for non-linear parameters. This needs to be a list with list
  entries corresponding to the selected bounds. The names of the list
  entries need to correspond to the model names. The
  \code{\link[DoseFinding]{defBnds}} function provides the default selection.
}

\item{control}{
  Control list for the optimization.\cr
  A list with entries: "nlminbcontrol", "optimizetol" and "gridSize".
  
  The entry nlminbcontrol needs to be a list and is passed directly to
  control argument in the nlminb function, that is used internally for
  models with 2 nonlinear parameters (e.g. sigmoid Emax or beta model).
    
  The entry optimizetol is passed directly to the tol argument of the
  optimize function, which is used for models with 1 nonlinear
  parameters (e.g. Emax or exponential model).

  The entry gridSize needs to be a list with entries dim1 and dim2
  giving the size of the grid for the gridsearch in 1d or 2d models.
}

\item{offset}{Either a numeric vector of the same length as dose and resp, or
a character vector denoting the column name in the data.}

\item{...}{Additional arguments to be passed to \code{glm} or \code{glm.nb}.
This is especially useful when a fitting error is returned. In these cases,
it may be useful to supply a \code{start} vector for the parameters.}
}
\value{
An object of class MCPMod if `returnS = FALSE`. Otherwise, a list
  containing an object of class MCPMod, the numeric vector \eqn{\mu}, and the
  numeric matrix \eqn{S}.
}
\description{
This function allows the user to implement the MCPMod function on negative
binomial, Poisson, and binary data, without having to write any additional
code. If analyzing survival data, see the
\code{\link[MCPModGeneral:MCPModSurv]{MCPModSurv}} function.
}
\details{
This function works by first fitting a glm with the chosen family and link.
The \eqn{\mu} vector and \eqn{S} matrix are extracted from the glm, and these
values are supplied to the MCPMod function, along with all user-defined
arguments. \cr Currently, the function can take the negative binomial and
Poisson family with a log, sqrt, identity, risk ratio, and log risk ratio
links, or a bernoulli family with a log, logit, probit, cauchit,
cloglog-link, identity, risk ratio, and log risk ratio links.
}
\examples{
# Analyze the binary migraine data from the DoseFinding package.
data(migraine)
models = Mods(linear = NULL, emax = 1, quadratic = c(-0.004), doses = migraine$dose)

# Now analyze using binomial weights
PFrate <- migraine$painfree/migraine$ntrt
migraine$pfrat = migraine$painfree / migraine$ntrt
MCPModGen("binomial","logit",returnS = TRUE, w = "ntrt", dose = "dose",
   resp = "pfrat", data = migraine, models = models, selModel = "aveAIC",
   Delta = 0.2)
}
\references{
Buckland, S. T., Burnham, K. P. and Augustin, N. H. (1997). Model
  selection an integral part of inference, \emph{Biometrics}, \bold{53},
  603--618
}
