% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_mc.R
\name{table.mc}
\alias{table.mc}
\title{Get matrix of observed transition frequencies}
\usage{
table.mc(z, labels)
}
\arguments{
\item{z}{vector of model indices (numerical or character)}

\item{labels}{fixed labels for models that should be included in transition matrix, e.g., \code{labels=1:20} or \code{c("m1","m2",...)}}
}
\value{
a square matrix with transition frequencies
}
\description{
Summarizes a sequence of discrete values by the observed transition frequencies.
}
\examples{
P <- matrix(c(.9,.1,0,
              .1,.6,.3,
              .2,.3,.5), 3, byrow=TRUE)
z <- sim.mc(1000, P)
table.mc(z, labels = 1:5)
}
