% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcm.R
\name{mcm}
\alias{mcm}
\title{Estimate and Test Inter-generational Social Mobility
Effect on an Outcome}
\usage{
mcm(
  formula,
  data,
  weights = 1,
  na.action = na.omit,
  origin,
  destination,
  family = gaussian(),
  contrasts = NULL,
  gee = FALSE,
  id = NULL,
  corstr = "exchangeable",
  displayresult = TRUE,
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can
be coerced to that class): a symbolic description of the model
to be fitted. A typical model used in studying social mobility
takes the form \code{response ~ origin*destination}, where
\code{respose} is the numeric response vector and \code{origin}
(\code{destination}) is a vector indicating the origin (destination).
The specification of \code{origin*destination} indicates the cross of
\code{origin} and \code{destination}, which is the same as \code{
origin + destination + origin:destination} where
\code{origin:destination} indicates the interaction of \code{origin}
and \code{destination}.}

\item{data}{an optional data frame, list or environment
(or object coercible by as.data.frame to a data frame)
containing the variables in the model. If not found in data,
the variables are taken from environment(formula),
typically the environment from which the function is called.}

\item{weights}{an optional vector of unit-level sampling weights to
be used in analysis.
Should be NULL or a numeric vector.}

\item{na.action}{a function which indicates what should
happen when the data contain NAs.The default is set by the
\code{na.action} setting in \code{options} and is
\code{na.fail} if that is unset.}

\item{origin}{a character indicating the column name of origin.}

\item{destination}{a character indicating the column name of destination.}

\item{family}{a character string, a function or the result of a call
to a family function describing the error distribution and link function
to be used in the model.}

\item{contrasts}{an optional list. The default is set as sum-to-zero
contrast.}

\item{gee}{logical. Should gee be used in estimating the model?}

\item{id}{a vector which identifies the clusters, which is required while
\code{gee} is used. The length of \code{id} should be the same as
the number of observations. Data are assumed to be sorted
so that observations on a cluster are contiguous rows for
all entities in the formula.}

\item{corstr}{a character string specifying
the correlation structure.
The following are permitted: \code{"independence"},
\code{"fixed"},
\code{"stat_M_dep"},
\code{"non_stat_M_dep"}, \code{"exchangeable"},
\code{"AR-M"} and \code{"unstructured"}.}

\item{displayresult}{logical. Should model results be displayed
after estimation. The default is \code{TRUE}.}

\item{\dots}{additional arguments to be passed to the function.}
}
\value{
A list containing:
\item{model}{Fitted generalized models of outcome on predictors.
See more on function \code{glm} in package \code{stats}.}
\item{origin_main}{Estimated main effects of origin.}
\item{destination_main}{Estimated main effects of destination.}
\item{mobility_estimates}{Estimated mobility effects.}
\item{mobility_se}{Standard errors of the estimated mobility effects.}
\item{mobility_sig}{Statistical significance of the the
estimated mobility effects.}
}
\description{
This function implements the mobility contrast model
designed for estimating and testing inter-generational
mobility effect on an outcome.
}
\examples{
library(MCM)
data('sim_moderate_het')
mcm(response ~ origin * destination, data = sim_moderate_het,
    origin = "origin",destination="destination")
}
