% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaRanking.R
\name{MetaRanking}
\alias{MetaRanking}
\title{Implementation of MetaRanking function for Multi-Criteria Decision Making Problems.}
\usage{
MetaRanking(decision, weights, cb, lambda, v, AB, CD)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}

\item{lambda}{A value in [0,1]. It is used in the calculation of the W index for WASPAS method.}

\item{v}{A value in [0,1]. It is used in the calculation of the Q index for VIKOR method.}

\item{AB}{A matrix (\emph{2} x \emph{n}). AB[1,] corresponds with the A extrem, and AB[2,] represents the B extrem of the domain of each criterion.}

\item{CD}{A matrix (\emph{2} x \emph{n}). CD[1,] corresponds with the C extrem, and CD[2,] represents the D extrem of the ideal reference of each criterion.}
}
\value{
\code{MetaRanking} returns a data frame which contains the rankings of the Multi-MOORA, RIM, TOPSISLinear, TOPSISVector, VIKOR, WASPAS Methods and the both MetaRankings of the alternatives.
}
\description{
The \code{MetaRanking} function internally calls functions  \code{MMOORA}, \code{RIM}, \code{TOPSISLinear}, \code{TOPSISVector}, \code{VIKOR} and \code{WASPAS} and then calculates a sum of the their rankings and an aggregated ranking by applying the \code{RankAggreg} package.
}
\examples{

 d <- matrix(c(1,2,5,3000,3750,4500),nrow = 3,ncol = 2)
 w <- c(0.5,0.5)
 cb <- c('min','max')
 lambda <- 0.5
 v <- 0.5
 AB <- matrix(c(1,5,3000,4500),nrow = 2,ncol=2)
 CD <- matrix(c(1,1,4500,4500),nrow = 2,ncol=2)
 MetaRanking(d,w,cb,lambda,v,AB,CD)
}

