% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.functions.R
\name{pDcalc}
\alias{pDcalc}
\title{Calculate plugin pD from a JAGS model with univariate likelihood for studies
with repeated measurements}
\usage{
pDcalc(
  obs1,
  obs2,
  fups = NULL,
  narm,
  NS,
  theta.result,
  resdev.result,
  likelihood = "normal",
  type = "time"
)
}
\arguments{
\item{obs1}{A matrix (study x arm) or array (study x arm x time point) containing
observed data for \code{y} (normal likelihood) or \code{r} (binomial or Poisson likelihood)
in each arm of each study. This will be the same array
used as data for the JAGS model.}

\item{obs2}{A matrix (study x arm) or array (study x arm x time point) containing
observed data for \code{se} (normal likelihood), \code{N} (binomial likelihood) or \code{E} (Poisson likelihood)
in each arm of each study. This will be the same array
used as data for the JAGS model.}

\item{fups}{A numeric vector of length equal to the number of studies,
containing the number of follow-up mean responses reported in each study. Required for
time-course MBNMA models (if \code{type="time"})}

\item{narm}{A numeric vector of length equal to the number of studies,
containing the number of arms in each study.}

\item{NS}{A single number equal to the number of studies in the dataset.}

\item{theta.result}{A matrix (study x arm) or array (study x arm x time point)
containing the posterior mean predicted means/probabilities/rate in each arm of each
study. This will be estimated by the JAGS model.}

\item{resdev.result}{A matrix (study x arm) or array (study x arm x time point)
containing the posterior mean residual deviance contributions in each arm of each
study. This will be estimated by the JAGS model.}

\item{likelihood}{A character object of any of the following likelihoods:
\itemize{
\item \code{univariate}
\item \code{binomial} (does not work with time-course MBNMA models)
\item \code{multivar.normal} (does not work with time-course MBNMA models)
}}

\item{type}{The type of MBNMA model fitted. Can be either \code{"time"} or \code{"dose"}}
}
\value{
A numeric value for the effective number of parameters, pD, calculated via the plugin method
}
\description{
Uses results from MBNMA JAGS models to calculate pD via the
plugin method \insertCite{spiegelhalter2002}{MBNMAtime}. Can only be used for models with known
standard errors or covariance matrices (typically univariate).
}
\details{
Method for calculating pD via the plugin method proposed by
\insertCite{spiegelhalter2002}{MBNMAtime}. Standard errors / covariance matrices must be assumed
to be known. To obtain values for theta.result and resdev.result these
parameters must be monitored when running the JAGS model.

For non-linear time-course MBNMA models residual deviance contributions may be skewed, which
can lead to non-sensical results when calculating pD via the plugin method.
Alternative approaches are to use pV (\code{pv}) as an approximation \insertCite{plummer2008}{MBNMAtime} or
pD calculated by Kullback–Leibler divergence (\code{pd.kl}) or using an optimism adjustment (\code{popt}) \insertCite{plummer2008}{MBNMAtime}.
}
\examples{
\donttest{
# Using the alogliptin dataset
network <- mb.network(alog_pcfb)

# Run Emax model saving predicted means and residual deviance contributions
emax <- mb.run(network, fun=temax(),
  parameters.to.save=c("theta", "resdev"), intercept=FALSE)

# Get matrices of observed data
jagsdat <- getjagsdata(network$data.ab)

# Plugin estimation of pD is problematic with non-linear models as it often leads to
#negative values, hence use of pV, pd.kl and popt as other measures for the effective
#number of parameters
pDcalc(obs1=jagsdat$y, obs2=jagsdat$se,
  fups=jagsdat$fups, narm=jagsdat$narm, NS=jagsdat$NS,
  theta.result = emax$BUGSoutput$mean$theta,
  resdev.result = emax$BUGSoutput$mean$resdev
  )
}
}
\references{
TO ADD pV REF
}
