## $Id: show-methods.R 583 2011-05-28 18:00:49Z sgibb $
##
## Copyright 2011 Sebastian Gibb
## <mail@sebastiangibb.de>
##
## This file is part of MALDIquant for R and related languages.
##
## MALDIquant is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## MALDIquant is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with MALDIquant. If not, see <http://www.gnu.org/licenses/>

## AbstractMassSpectrumData 
setMethod(f="show",
    signature=signature(object="AbstractMassSpectrumData"),
    definition=function(object) {
    
    groups <- c("S4 class type",
                "Number of m/z values", 
                "Range of m/z values",
                "Range of intensity values");

    values <- c(class(object)[1], 
        length(object@mass), 
        paste(round(range(object@mass), digits=3), collapse=" - "),
        paste(round(range(object@intensity), digits=3), collapse=" - "));

    if (!is.null(object@metaData$name)) {
        groups <- c(groups, "Name");    
        values <- c(values, object@metaData$name);
    }

    groups <- format(groups, justify="left");
    values <- format(values, justify="left");

    if (!is.null(object@metaData$file)) {
        groups <- c(groups, "File");    
        groups <- format(groups, justify="left");

        ## to avoid newlines in other values don't format filenames
        ## (they could be very long)
        values <- c(values, object@metaData$file);
    }

    for (i in seq(along=groups)) {
        cat(groups[i], ": ", values[i], "\n", sep="");
    }
});

