% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_MCLfastas.R
\name{format_MCLfastas}
\alias{format_MCLfastas}
\title{Format all raw GenBank fastas to single OrthoMCL compatible fasta file}
\usage{
format_MCLfastas(fa_dir, genbnk_id = 4)
}
\arguments{
\item{fa_dir}{Path to the directory where all raw GenBank files are stored. Note, all file names must be changed to a 4-letter code representing each species and have '.fasta' file descriptor}

\item{genbnk_id}{(Only necessary for the deprecated version of fasta headers) The index of the sequence ID in the GenBank pipe-separated annotation line (default: 4)}
}
\value{
The path to the final OrthoMCL compatible fasta file
}
\description{
Creates the composite fasta file for use in running OrthoMCL and/or submitting to www.orthomcl.org
}
\examples{

# Not run ~ directory structure depends on system
dir <- system.file('extdata', 'fasta_dir', package='MAGNAMWAR')
dir <- paste(dir,'/',sep='')
formatted_file <- format_MCLfastas(dir)
}
