
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_DirichletMultinomial_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <bool propto, typename T1__>
typename boost::math::tools::promote_args<T1__>::type
dirichlet_multinomial_lpmf(const std::vector<int>& x,
                               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            fun_scalar_t__ ans;
            (void) ans;  // dummy to suppress unused var warning
            stan::math::initialize(ans, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ans,DUMMY_VAR__);


            current_statement_begin__ = 20;
            stan::math::assign(ans, 0.0);
            current_statement_begin__ = 21;
            for (int ii = 1; ii <= num_elements(x); ++ii) {

                current_statement_begin__ = 22;
                stan::math::assign(ans, ((ans + stan::math::lgamma((get_base1(x,ii,"x",1) + get_base1(eta,ii,"eta",1)))) - stan::math::lgamma(get_base1(eta,ii,"eta",1))));
            }
            current_statement_begin__ = 24;
            return stan::math::promote_scalar<fun_return_scalar_t__>(((ans + stan::math::lgamma(sum(eta))) - stan::math::lgamma((sum(x) + sum(eta)))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T1__>
typename boost::math::tools::promote_args<T1__>::type
dirichlet_multinomial_lpmf(const std::vector<int>& x,
                               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta, std::ostream* pstream__) {
    return dirichlet_multinomial_lpmf<false>(x,eta, pstream__);
}


struct dirichlet_multinomial_lpmf_functor__ {
    template <bool propto, typename T1__>
        typename boost::math::tools::promote_args<T1__>::type
    operator()(const std::vector<int>& x,
                               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta, std::ostream* pstream__) const {
        return dirichlet_multinomial_lpmf(x, eta, pstream__);
    }
};

template <bool propto, typename T1__>
typename boost::math::tools::promote_args<T1__>::type
Dirichlet_Multinomial_lpmf(const std::vector<std::vector<int> >& X,
                               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<int> D(2, 0);
            stan::math::fill(D, std::numeric_limits<int>::min());
            fun_scalar_t__ ans;
            (void) ans;  // dummy to suppress unused var warning
            stan::math::initialize(ans, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ans,DUMMY_VAR__);
            fun_scalar_t__ seta;
            (void) seta;  // dummy to suppress unused var warning
            stan::math::initialize(seta, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(seta,DUMMY_VAR__);
            fun_scalar_t__ slgeta;
            (void) slgeta;  // dummy to suppress unused var warning
            stan::math::initialize(slgeta, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(slgeta,DUMMY_VAR__);


            current_statement_begin__ = 33;
            stan::math::assign(D, dims(X));
            current_statement_begin__ = 35;
            stan::math::assign(seta, sum(eta));
            current_statement_begin__ = 36;
            stan::math::assign(slgeta, 0.0);
            current_statement_begin__ = 37;
            for (int jj = 1; jj <= get_base1(D,2,"D",1); ++jj) {

                current_statement_begin__ = 38;
                stan::math::assign(slgeta, (slgeta + stan::math::lgamma(get_base1(eta,jj,"eta",1))));
            }
            current_statement_begin__ = 41;
            stan::math::assign(ans, 0.0);
            current_statement_begin__ = 42;
            for (int ii = 1; ii <= get_base1(D,1,"D",1); ++ii) {

                current_statement_begin__ = 43;
                for (int jj = 1; jj <= get_base1(D,2,"D",1); ++jj) {

                    current_statement_begin__ = 44;
                    stan::math::assign(ans, (ans + stan::math::lgamma((get_base1(get_base1(X,ii,"X",1),jj,"X",2) + get_base1(eta,jj,"eta",1)))));
                }
                current_statement_begin__ = 46;
                stan::math::assign(ans, (ans - stan::math::lgamma((sum(get_base1(X,ii,"X",1)) + seta))));
            }
            current_statement_begin__ = 48;
            stan::math::assign(ans, (ans + (get_base1(D,1,"D",1) * (stan::math::lgamma(seta) - slgeta))));
            current_statement_begin__ = 49;
            return stan::math::promote_scalar<fun_return_scalar_t__>(ans);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T1__>
typename boost::math::tools::promote_args<T1__>::type
Dirichlet_Multinomial_lpmf(const std::vector<std::vector<int> >& X,
                               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta, std::ostream* pstream__) {
    return Dirichlet_Multinomial_lpmf<false>(X,eta, pstream__);
}


struct Dirichlet_Multinomial_lpmf_functor__ {
    template <bool propto, typename T1__>
        typename boost::math::tools::promote_args<T1__>::type
    operator()(const std::vector<std::vector<int> >& X,
                               const Eigen::Matrix<T1__, Eigen::Dynamic,1>& eta, std::ostream* pstream__) const {
        return Dirichlet_Multinomial_lpmf(X, eta, pstream__);
    }
};

class model_DirichletMultinomial : public prob_grad {
private:
    int nG;
    int nL;
    vector<vector<int> > X;
    int nLrho;
    vector<int> iLrho;
public:
    model_DirichletMultinomial(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_DirichletMultinomial(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_DirichletMultinomial_namespace::model_DirichletMultinomial";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nG", "int", context__.to_vec());
        nG = int(0);
        vals_i__ = context__.vals_i("nG");
        pos__ = 0;
        nG = vals_i__[pos__++];
        context__.validate_dims("data initialization", "nL", "int", context__.to_vec());
        nL = int(0);
        vals_i__ = context__.vals_i("nL");
        pos__ = 0;
        nL = vals_i__[pos__++];
        context__.validate_dims("data initialization", "X", "int", context__.to_vec(nL,nG));
        validate_non_negative_index("X", "nL", nL);
        validate_non_negative_index("X", "nG", nG);
        X = std::vector<std::vector<int> >(nL,std::vector<int>(nG,int(0)));
        vals_i__ = context__.vals_i("X");
        pos__ = 0;
        size_t X_limit_1__ = nG;
        for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
            size_t X_limit_0__ = nL;
            for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                X[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "nLrho", "int", context__.to_vec());
        nLrho = int(0);
        vals_i__ = context__.vals_i("nLrho");
        pos__ = 0;
        nLrho = vals_i__[pos__++];
        context__.validate_dims("data initialization", "iLrho", "int", context__.to_vec(nLrho));
        validate_non_negative_index("iLrho", "nLrho", nLrho);
        iLrho = std::vector<int>(nLrho,int(0));
        vals_i__ = context__.vals_i("iLrho");
        pos__ = 0;
        size_t iLrho_limit_0__ = nLrho;
        for (size_t i_0__ = 0; i_0__ < iLrho_limit_0__; ++i_0__) {
            iLrho[i_0__] = vals_i__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"nG",nG,1);
        check_greater_or_equal(function__,"nL",nL,1);
        for (int k0__ = 0; k0__ < nL; ++k0__) {
            for (int k1__ = 0; k1__ < nG; ++k1__) {
                check_greater_or_equal(function__,"X[k0__][k1__]",X[k0__][k1__],0);
            }
        }
        check_greater_or_equal(function__,"nLrho",nLrho,0);
        check_less_or_equal(function__,"nLrho",nLrho,nL);
        for (int k0__ = 0; k0__ < nLrho; ++k0__) {
            check_greater_or_equal(function__,"iLrho[k0__]",iLrho[k0__],1);
            check_less_or_equal(function__,"iLrho[k0__]",iLrho[k0__],nL);
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += (nG - 1);
        ++num_params_r__;
    }

    ~model_DirichletMultinomial() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "vector_d", context__.to_vec(nG));
        // generate_declaration alpha
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(nG));
        for (int j1__ = 0U; j1__ < nG; ++j1__)
            alpha(j1__) = vals_r__[pos__++];
        try {
            writer__.simplex_unconstrain(alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("eta")))
            throw std::runtime_error("variable eta missing");
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        context__.validate_dims("initialization", "eta", "double", context__.to_vec());
        // generate_declaration eta
        double eta(0);
        eta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,eta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable eta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha;
        (void) alpha;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha = in__.simplex_constrain(nG,lp__);
        else
            alpha = in__.simplex_constrain(nG);

        T__ eta;
        (void) eta;  // dummy to suppress unused var warning
        if (jacobian__)
            eta = in__.scalar_lb_constrain(0,lp__);
        else
            eta = in__.scalar_lb_constrain(0);


        // transformed parameters


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {

            current_statement_begin__ = 70;
            lp_accum__.add(Dirichlet_Multinomial_lpmf<propto__>(X, multiply(eta,alpha), pstream__));
            current_statement_begin__ = 74;
            lp_accum__.add((-(2) * log((1 + eta))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("eta");
        names__.push_back("rho");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nG);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLrho);
        dims__.push_back(nG);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_DirichletMultinomial_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d alpha = in__.simplex_constrain(nG);
        double eta = in__.scalar_lb_constrain(0);
        for (int k_0__ = 0; k_0__ < nG; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        vars__.push_back(eta);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning



        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters

        if (!include_gqs__) return;
        // declare and define generated quantities
        vector<vector_d> rho(nLrho, (vector_d(static_cast<Eigen::VectorXd::Index>(nG))));
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            current_statement_begin__ = 80;
            if (as_bool(logical_gt(nLrho,0))) {

                current_statement_begin__ = 81;
                for (int ii = 1; ii <= nLrho; ++ii) {

                    current_statement_begin__ = 82;
                    stan::math::assign(get_base1_lhs(rho,ii,"rho",1), dirichlet_rng(add(to_vector(get_base1(X,get_base1(iLrho,ii,"iLrho",1),"X",1)),multiply(eta,alpha)), base_rng__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nLrho; ++k0__) {
            stan::math::check_simplex(function__,"rho[k0__]",rho[k0__]);
        }

        // write generated quantities
        for (int k_1__ = 0; k_1__ < nG; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nLrho; ++k_0__) {
                vars__.push_back(rho[k_0__][k_1__]);
            }
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_DirichletMultinomial";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nG; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "eta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= nG; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLrho; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= (nG - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "eta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= (nG - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLrho; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

} // namespace




#endif
