/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.stats.descriptive;

public class MeanVar
implements Cloneable {
    protected double mean = 0.0;
    protected double s = 0.0;
    protected int n = 0;

    public MeanVar(double value) {
        this.addValue(value);
    }

    public MeanVar(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.addValue(data[i]);
        }
    }

    protected MeanVar(int n, double mean, double s) {
        this.n = n;
        this.mean = mean;
        this.s = s;
    }

    public void addValue(double newValue) {
        double delta = newValue - this.mean;
        ++this.n;
        this.mean += delta / (double)this.n;
        this.s += delta * (newValue - this.mean);
    }

    public Object clone() {
        return new MeanVar(this.n, this.mean, this.s);
    }

    public double getMean() {
        return this.mean;
    }

    public int getN() {
        return this.n;
    }

    public double getSd() {
        if (this.n <= 1) {
            return Double.NaN;
        }
        return Math.sqrt(this.s / (double)(this.n - 1));
    }

    public double getVariance() {
        if (this.n <= 1) {
            return Double.NaN;
        }
        return this.s / (double)(this.n - 1);
    }
}

