/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import java.util.List;
import uk.ac.rhul.cs.graph.Edge;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphLayoutAlgorithm;
import uk.ac.rhul.cs.graph.Layout;

public class FruchtermanReingoldLayoutAlgorithm
extends GraphLayoutAlgorithm {
    private int iterationCount = 500;
    private double coolingExponent = 0.99;

    public FruchtermanReingoldLayoutAlgorithm() {
    }

    public FruchtermanReingoldLayoutAlgorithm(Graph graph) {
        super(graph);
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public Layout getResults() {
        int i;
        int numberOfNodes = this.graph.getNodeCount();
        double maxDelta = numberOfNodes;
        double repulseRadius = (double)this.iterationCount * maxDelta;
        double area = maxDelta * maxDelta;
        double frk = Math.sqrt(area / (double)numberOfNodes);
        if (numberOfNodes == 0) {
            return new Layout(this.graph);
        }
        NodeData[] nodeDataArray = new NodeData[numberOfNodes];
        for (i = 0; i < numberOfNodes; ++i) {
            nodeDataArray[i] = new NodeData();
        }
        List<Edge> edges = this.graph.getEdgeList();
        double xd = 0.0;
        for (Edge edge : edges) {
            if (edge.weight < 0.0) {
                edge.weight = 1.0;
            }
            if (!(edge.weight > xd)) continue;
            xd = edge.weight;
        }
        for (Edge edge : edges) {
            edge.weight /= xd;
        }
        for (int iter = 0; iter < this.iterationCount; ++iter) {
            double force;
            double ded;
            double yd;
            double t = maxDelta * Math.pow(1.0 - (double)iter / (double)this.iterationCount, this.coolingExponent);
            for (i = 0; i < numberOfNodes; ++i) {
                NodeData firstNode = nodeDataArray[i];
                for (int j = i + 1; j < numberOfNodes; ++j) {
                    NodeData secondNode = nodeDataArray[j];
                    xd = firstNode.x - secondNode.x;
                    yd = firstNode.y - secondNode.y;
                    ded = Math.sqrt(xd * xd + yd * yd);
                    if (ded == 0.0) continue;
                    xd /= ded;
                    yd /= ded;
                    force = frk * frk * (1.0 / ded - ded * ded / repulseRadius);
                    firstNode.addDxDy(xd *= force, yd *= force);
                    secondNode.addDxDy(-xd, -yd);
                }
            }
            for (Edge edge : edges) {
                NodeData firstNode = nodeDataArray[edge.source];
                NodeData secondNode = nodeDataArray[edge.target];
                xd = firstNode.x - secondNode.x;
                yd = firstNode.y - secondNode.y;
                ded = Math.sqrt(xd * xd + yd * yd);
                if (ded == 0.0) continue;
                force = -ded * ded / frk * edge.weight;
                firstNode.addDxDy(xd *= force, yd *= force);
                secondNode.addDxDy(-xd, -yd);
            }
            for (NodeData nodeData : nodeDataArray) {
                ded = nodeData.getVelocity();
                if (ded > t) {
                    nodeData.scaleDxDy(t / ded);
                }
                nodeData.move();
            }
        }
        Layout layout = new Layout(this.graph);
        for (i = 0; i < numberOfNodes; ++i) {
            layout.setCoordinates(i, nodeDataArray[i].x, nodeDataArray[i].y);
        }
        return layout;
    }

    public void setIterationCount(int iterationCount) {
        if (iterationCount >= 1) {
            this.iterationCount = iterationCount;
        }
    }

    private class NodeData {
        double x = Math.random();
        double y = Math.random();
        double dx = 0.0;
        double dy = 0.0;

        public void addDxDy(double dx0, double dy0) {
            this.dx += dx0;
            this.dy += dy0;
        }

        public double getVelocity() {
            return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        }

        public void scaleDxDy(double factor) {
            this.dx *= factor;
            this.dy *= factor;
        }

        public void move() {
            this.x += this.dx;
            this.y += this.dy;
            this.dx = 0.0;
            this.dy = 0.0;
        }
    }
}

