/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.io;

import java.util.Arrays;
import java.util.TreeSet;
import uk.ac.rhul.cs.cl1.io.EdgeListReader;
import uk.ac.rhul.cs.cl1.io.GraphReader;
import uk.ac.rhul.cs.cl1.io.SIFReader;
import uk.ac.rhul.cs.utils.StringUtils;

public class GraphReaderFactory {
    public static GraphReader fromFormat(Format format) {
        switch (format) {
            case SIF: {
                return new SIFReader();
            }
            case EDGE_LIST: {
                return new EdgeListReader();
            }
        }
        return null;
    }

    public static GraphReader fromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        return GraphReaderFactory.fromFormat(Format.fromFilename(filename));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        EDGE_LIST,
        SIF("sif");

        TreeSet<String> extensions = null;

        private Format() {
        }

        private Format(String extension) {
            this.extensions = new TreeSet();
            this.extensions.add(extension);
        }

        private Format(String[] extensions) {
            this.extensions = new TreeSet<String>(Arrays.asList(extensions));
        }

        public static Format fromFilename(String filename) {
            String ext = StringUtils.getFileExtension(filename);
            for (Format format : Format.values()) {
                if (format.extensions == null || !format.extensions.contains(ext)) continue;
                return format;
            }
            return EDGE_LIST;
        }
    }
}

