/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.array;

import com.sosnoski.util.GrowableBase;

public abstract class ArrayBase
extends GrowableBase {
    protected int m_countPresent;

    public ArrayBase(int n, int n2, Class clazz) {
        super(n, n2, clazz);
    }

    public ArrayBase(int n, Class clazz) {
        this(n, Integer.MAX_VALUE, clazz);
    }

    public ArrayBase(ArrayBase arrayBase) {
        super(arrayBase);
        System.arraycopy(arrayBase.getArray(), 0, this.getArray(), 0, arrayBase.m_countPresent);
        this.m_countPresent = arrayBase.m_countPresent;
    }

    protected static Object getArray(ArrayBase arrayBase) {
        return arrayBase.getArray();
    }

    protected final int getAddIndex() {
        int n = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return n;
    }

    protected void makeInsertSpace(int n) {
        if (n >= 0 && n <= this.m_countPresent) {
            if (++this.m_countPresent > this.m_countLimit) {
                this.growArray(this.m_countPresent);
            }
            if (n < this.m_countPresent - 1) {
                Object object = this.getArray();
                System.arraycopy(object, n, object, n + 1, this.m_countPresent - n - 1);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
    }

    public void remove(int n, int n2) {
        if (n >= 0 && n2 <= this.m_countPresent && n <= n2) {
            if (n2 < this.m_countPresent) {
                int n3 = n - n2;
                Object object = this.getArray();
                System.arraycopy(object, n2, object, n, this.m_countPresent - n2);
                this.discardValues(this.m_countPresent + n3, this.m_countPresent);
                this.m_countPresent += n3;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("Invalid remove range");
        }
    }

    public void remove(int n) {
        this.remove(n, n + 1);
    }

    public final int size() {
        return this.m_countPresent;
    }

    public void setSize(int n) {
        if (n > this.m_countLimit) {
            this.growArray(n);
        } else if (n < this.m_countPresent) {
            this.discardValues(n, this.m_countPresent);
        }
        this.m_countPresent = n;
    }

    public final void clear() {
        this.setSize(0);
    }

    protected Object buildArray(Class clazz, int n, int n2) {
        if (n + n2 <= this.m_countPresent) {
            return super.buildArray(clazz, n, n2);
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

