% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.R
\name{plot_RLum}
\alias{plot_RLum}
\title{General plot function for RLum S4 class objects}
\usage{
plot_RLum(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}. Optional a \link{list} containing objects of
class \linkS4class{RLum} can be provided. In this case the function tries to plot
every object in this list according to its \code{RLum} class.}

\item{...}{further arguments and graphical parameters that will be passed
to the specific plot functions. The only argument that is supported directly is \code{main}
(setting the plot title). In contrast to the normal behaviour \code{main} can be here provided as
\link{list} and the arguments in the list will dispatched to the plots if the \code{object}
is of type \code{list} as well.}
}
\value{
Returns a plot.
}
\description{
Function calls object specific plot functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for plotting specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the
corresponding plot function will be selected.  Allowed arguments can be
found in the documentations of each plot function.

\tabular{lll}{
\strong{object} \tab \tab \strong{corresponding plot function} \cr
\linkS4class{RLum.Data.Curve} \tab : \tab \link{plot_RLum.Data.Curve} \cr
\linkS4class{RLum.Data.Spectrum} \tab : \tab \link{plot_RLum.Data.Spectrum}\cr
\linkS4class{RLum.Data.Image} \tab : \tab \link{plot_RLum.Data.Image}\cr
\linkS4class{RLum.Analysis} \tab : \tab \link{plot_RLum.Analysis}\cr
\linkS4class{RLum.Results} \tab : \tab \link{plot_RLum.Results}
}
}
\note{
The provided plot output depends on the input object.
}
\section{Function version}{
 0.4.3 (2018-01-21 17:22:38)
}

\examples{

#load Example data
data(ExampleData.CW_OSL_Curve, envir = environment())

#transform data.frame to RLum.Data.Curve object
temp <- as(ExampleData.CW_OSL_Curve, "RLum.Data.Curve")

#plot RLum object
plot_RLum(temp)


}
\seealso{
\link{plot_RLum.Data.Curve}, \linkS4class{RLum.Data.Curve}, \link{plot_RLum.Data.Spectrum},
\linkS4class{RLum.Data.Spectrum}, \link{plot_RLum.Data.Image}, \linkS4class{RLum.Data.Image},
\link{plot_RLum.Analysis}, \linkS4class{RLum.Analysis}, \link{plot_RLum.Results},
\linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2018). plot_RLum(): General plot function for RLum S4 class objects. Function version 0.4.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{dplot}
