% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_LuminescenceSignals.R
\name{model_LuminescenceSignals}
\alias{model_LuminescenceSignals}
\title{Model Luminescence Signals (wrapper)}
\usage{
model_LuminescenceSignals(model, sequence, lab.dose_rate = 1,
  simulate_sample_history = FALSE, plot = TRUE, verbose = TRUE,
  show.structure = FALSE, ...)
}
\arguments{
\item{model}{\code{\link{character}} (\bold{required}): set model to be used. Available models are:
"Bailey2001", "Bailey2002", "Bailey2004", "Pagonis2007", "Pagonis2008"}

\item{sequence}{\code{\link{list}} (\bold{required}): set sequence to model as \code{\link{list}} or as *.seq file from the
Riso sequence editor. To simulate SAR measurements there is an extra option to set the sequence list (cf. details).}

\item{lab.dose_rate}{\code{\link{numeric}} (with default): laboratory dose rate in XXX
Gy/s for calculating seconds into Gray in the *.seq file.}

\item{simulate_sample_history}{\code{\link{logical}} (with default): FALSE (with default): simulation begins at laboratory conditions, TRUE: simulations begins at crystallization (all levels 0)
process}

\item{plot}{\code{\link{logical}} (with default): Enables or disables plot output}

\item{verbose}{\code{\link{logical}} (with default): Verbose mode on/off}

\item{show.structure}{\code{\link{logical}} (with default): Shows the structure of the result.
Recommended to show record.id to analyse concentrations.}

\item{...}{further arguments and graphical parameters passed to
\code{\link{plot.default}}. See details for further information.}
}
\description{
Wrapper for the function \code{\link[RLumModel]{model_LuminescenceSignals}} from the package
\link[RLumModel]{RLumModel-package}. For the further details and examples please
see the manual of this package.
}
\section{Function version}{
 0.1.0 (2016-05-02 09:36:06)
}
\author{
Johannes Friedrich, University of Bayreuth (Germany),\cr
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaige (France), \cr
\cr R Luminescence Package Team}

