% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RLum.Data.Image-class.R
\docType{class}
\name{RLum.Data.Image-class}
\alias{RLum.Data.Image-class}
\alias{get_RLum,RLum.Data.Image-method}
\alias{set_RLum,RLum.Data.Image-method}
\title{Class \code{"RLum.Data.Image"}}
\usage{
\S4method{set_RLum}{RLum.Data.Image}(class, recordType, curveType, data, info)

\S4method{get_RLum}{RLum.Data.Image}(object, info.object)
}
\arguments{
\item{class}{\code{\link{character}}: name of the \code{RLum} class to create}

\item{recordType}{\code{\link{character}}: record type (e.g. "OSL")}

\item{curveType}{\code{\link{character}}: curve type (e.g. "predefined" or "measured")}

\item{data}{\code{\link{matrix}}: raw curve data}

\item{info}{\code{\link{list}}: info elements}

\item{object}{an object of class \code{\linkS4class{RLum.Data.Image}}}

\item{info.object}{object of class "list" containing further meta information objects}
}
\description{
Class for luminescence image data (TL/OSL/RF).
}
\section{Methods (by generic)}{
\itemize{
\item \code{set_RLum}: Construction method for RLum.Data.Image object. The slot info is optional
and predefined as empty list by default..

\item \code{get_RLum}: Accessor method for RLum.Data.Image object. The argument info.object is
 optional to directly access the info elements. If no info element name is
 provided, the raw image data (RasterBrick) will be returned.
}}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class "character" containing the type of the curve (e.g. "OSL image", "TL image")}

\item{\code{curveType}}{Object of class "character" containing curve type, allowed values are measured or predefined}

\item{\code{data}}{Object of class "RasterBrick" containing images (raster data).}

\item{\code{info}}{Object of class "list" containing further meta information objects}
}}
\note{
The class should only contain data for a set of images. For additional
elements the slot \code{info} can be used.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("RLum.Data.Image", ...)}.
}

\section{Class version}{
 0.2.0
}
\examples{
showClass("RLum.Data.Image")

##so far no further example available
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
}
\seealso{
\code{\linkS4class{RLum}}, \code{\linkS4class{RLum.Data}},
\code{\link{plot_RLum}}
}
\keyword{classes}

