\name{Calc_MinDose4}
\alias{Calc_MinDose4}
\title{
Apply the (un-)logged four parameter minimum age model (MAM 4) after Galbraith et al. (1999) to a given De distribution
}
\description{
Function to fit the (un-)logged four parameter minimum dose model (MAM 4) to De data.
}
\usage{
Calc_MinDose4(input.data,
              sigmab,
              log = TRUE,
              sample.id = "unknown sample",
              gamma.xlb = 0.1,
              gamma.xub = 100,
              mu.xlb = 1,
              mu.xub = 100,
              sigma.xlb = 0.001,
              sigma.xub = 5.00,
              init.gamma = 5,
              init.mu = 10,
              init.sigma = 0.6,
              init.p0 = 0.01,
              calc.ProfileLikelihoods = TRUE,
              console.ProfileLikelihoods = FALSE,
              console.extendedOutput = FALSE,
              output.file = FALSE,
              output.filename = "default",
              output.plot = FALSE,
              output.indices = 4)
}
\arguments{
  \item{input.data}{\link{data.frame} (\bold{required}): two column data frame with De values and corresponding De errors
}
  \item{sigmab}{\link{numeric}  (\bold{required}): spread in De values given as a fraction (e.g. 0.2). This value represents the expected overdispersion in the data should the sample be well-bleached (Cunningham & Walling 2012, p. 100).
}
  \item{log}{\link{logical} (with default): fit the (un-)logged three parameter minimum dose model to De data
}
  \item{sample.id}{\link{character} (with default): sample id
}
  \item{gamma.xlb}{\link{numeric} (with default): lower boundary of gamma 
}
  \item{gamma.xub}{\link{numeric} (with default): upper boundary of gamma 
}
  \item{mu.xlb}{\link{numeric} (with default): lower boundary of mu 
}
  \item{mu.xub}{\link{numeric} (with default): upper boundary of mu 
}
  \item{sigma.xlb}{\link{numeric} (with default): lower boundary of sigma 
}
  \item{sigma.xub}{\link{numeric} (with default): upper boundary of sigma 
}
  \item{init.gamma}{\link{numeric} (with default): starting value of gamma 
}
  \item{init.mu}{\link{numeric} (with default): starting value of mu 
}
  \item{init.sigma}{\link{numeric} (with default): starting value of sigma
}
  \item{init.p0}{\link{numeric} (with default): starting value of p0
}
  \item{calc.ProfileLikelihoods}{\link{logical} (with default): calculate profile log likelihood functions for gamma, mu, sigma, p0. See \code{output.indices}.
}
  \item{console.ProfileLikelihoods}{\link{logical} (with default): print profile log likelihood functions for gamma, sigma, p0 to console.
}
  \item{console.extendedOutput}{\link{logical} (with default): extended terminal output

}
  \item{output.file}{\link{logical} (with default): save results to \code{output.filename}-4R(-UL).res file. See \code{output.filename}.
}
  \item{output.filename}{\link{character} (with default): desired filename, else results are saved to default-4R(-UL).res 
}
  \item{output.plot}{\link{logical} (with default): plot output
}
  \item{output.indices}{\link{numeric} (with default): requires \code{calc.ProfileLikelihoods}=\code{TRUE}. Indices: 1 = gamma, 2 = gamma/mu, 3 = gamma/mu/sigma, 4 = gamma/mu/sigma/p0
}
}
\details{

 \bold{Parameters}

This model has four parameters:

\tabular{rl}{
\code{gamma}: \tab minimum dose on the log scale \cr
\code{mu}: \tab mean of the non-truncated normal distribution \cr
\code{sigma}: \tab spread in ages above the minimum \cr
\code{p0}: \tab proportion of grains at gamma \cr
}

  \bold{(Un-)logged model}

In the original version of the three-parameter minimum dose model, the basic data are the natural logarithms of the De estimates and relative standard errors of the De estimates. This model will be applied if \code{log = TRUE}.

If \code{log = FALSE}, the modified un-logged model will be applied instead. This has essentially the same form as the original version. \code{gamma} and \code{sigma} are in Gy and \code{gamma} becomes the minimum true dose in the population.

While the original (logged) version of the mimimum dose model may be appropriate for most samples (i.e. De distributions), the modified (un-logged) version is specially designed for modern-age and young samples containing negative, zero or near-zero De estimates (Arnold et al. 2009, p. 323).

  \bold{Boundaries}

Depending on the data, the upper and lower bounds for gamma (\code{gamma.xlb} and \code{gamma.xub}) and mu (\code{mu.xlb} and \code{mu.xub}) need to be specified. If the final estimate of gamma or mu is on the boundary, \code{gamma.xlb} and \code{gamma.xub} (\code{mu.xlb} and \code{mu.xub} respectively) need to be adjusted appropriately, so that gamma and mu lie within the bounds. The same applies for sigma boundaries (\code{sigma.xlb} and \code{sigma.xub})

 \bold{Initial values}

The log likelihood calculations use the \link{nlminb} function. Accordingly, initial values for the four parameters \code{init.gamma}, \code{init.sigma}, \code{init.mu} and \code{init.p0} need to be specified.
}

\value{
A terminal output is provided. A plot (\link{postscript}) and a file containing statistical results are provided if wanted. In addition a list is returned containing the following element:

  \item{results}{data frame containing statistical results.
  }
}
\references{
Arnold, L.J., Roberts, R.G., Galbraith, R.F. & DeLong, S.B., 2009. A revised burial dose estimation procedure for optical dating of young and modern-age sediments. Quaternary Geochronology, 4, pp. 306-325.

Galbraith, R.F. & Laslett, G.M., 1993. Statistical models for mixed fission track ages. Nuclear Tracks Radiation Measurements, 4, pp. 459-470.

Galbraith, R.F., Roberts, R.G., Laslett, G.M., Yoshida, H. & Olley, J.M., 1999. Optical dating of single grains of quartz from Jinmium rock shelter, northern Australia. Part I: experimental design and statistical models. Archaeometry, 41, pp. 339-364.

Galbraith, R.F., 2005. Statistics for Fission Track Analysis, Chapman & Hall/CRC, Boca Raton.

Galbraith, R.F. & Roberts, R.G., 2012. Statistical aspects of equivalent dose and error calculation and display in OSL dating: An overview and some recommendations. Quaternary Geochronology, 11, pp. 1-27.

\bold{Further reading}

Arnold, L.J. & Roberts, R.G., 2009. Stochastic modelling of multi-grain equivalent dose (De) distributions: Implications for OSL dating of sediment mixtures. Quaternary Geochronology, 4, pp. 204-230.

Bailey, R.M. & Arnold, L.J., 2006. Statistical modelling of single grain quartz De distributions and an assessment of procedures for estimating burial dose. Quaternary Science Reviews, 25, pp. 2475-2502.

Cunningham, A.C. & Wallinga, J., 2012. Realizing the potential of fluvial archives using robust OSL chronologies. Quaternary Geochronology, 12, pp. 98-106.

Rodnight, H., Duller, G.A.T., Wintle, A.G. & Tooth, S., 2006. Assessing the reproducibility and accuracy of optical dating of fluvial deposits. Quaternary Geochronology, 1, pp. 109-120.

Rodnight, H., 2008. How many equivalent dose values are needed to obtain a reproducible distribution?. Ancient TL, 26, pp. 3-10.
}
\author{
Original S script: Rex Galbraith, University College London (UK), 2010

Revised R script: Christoph Burow, University of Cologne (Germany), 2012
}
\note{
The default boundary and starting values for \emph{gamma}, \emph{mu}, \emph{sigma} and \emph{p0} may only be appropriate for some De data sets and may need to be changed for other data. This is especially true when the un-logged version is applied.
}
\seealso{
  \link{nlminb},
  \link{postscript},
  \link{Calc_CentralDose},
  \link{Calc_CommonDose},
  \link{Calc_FiniteMixture},
  \link{Calc_FuchsLang2001},
  \link{Calc_MinDose3}
}
\examples{
## load example data
data(ExampleData.DeValues)

## apply the logged minimum dose model
Calc_MinDose4(ExampleData.DeValues, 
              sigmab = 0.05, gamma.xub = 10000, mu.xub = 10000, init.p0 = 0.4,
              output.file = FALSE,output.plot = FALSE)
}
